let PagosAutomatizadosEditController = {
	language: null,
	id: '',
	data: '',

	resetData() {
		let self = this;

		self.language = pf.const.language_table;
		self.id = atob(sessionStorage.getItem('idPagoAut'));
		self.data = '';
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1330 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'btn-save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLanguage();
		self.applyEvents();

		self.getScheduledPayment();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.pagosAutomatizados.sharedEvents(self, 'pagosAutomatizadosEditCountry', 'pagosAutomatizadosEdit');

		// Guardar pago automatizado
		$('#btn-save').on('click', function() {
			self.getValues();
		});
	},

	getScheduledPayment() {
		let self = this;

		ajaxComunCallWithCallback('getScheduledPayment', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let size = ajaxReturn.result.length;
				for(let i = 0; i < size; i++) {
					if(ajaxReturn.result[i].id == self.id) {
						self.data = ajaxReturn.result[i];
						break;
					}
				}

				self.renderValues();
			}
		});
	},

	renderValues() {
		let self = this;

		$('#tiempoEntreEjecuciones').val(self.data.TiempoEntreEjecuciones);
		$('#unidadDeTiempo').val(self.data.UnidadDeTiempo);
		$('#pais').val(self.data.country);
		$('#ultimaEjecucion').val(self.data.UltimaEjecucion);
		if(self.data.Activa == '1') {
			$('#activa').prop('checked', true);
		}
		$('#email').val(self.data.MailTo);
		$('#mailHead').val(self.data.Asunto);
		$('#mailBody').val(self.data.Cuerpo);

		$('#descUsuarioANotificar').val(self.data.UsuarioANotificarDesc);
		$('#usuarioANotificar').text(self.data.UsuarioANotificar);
		if(self.data.UsuarioANotificar != '') {
			$('#userDelete').show();
		}
		$('#descGrupoANotificar').val(self.data.GrupoANotificarDesc);
		$('#grupoANotificar').text(self.data.GrupoANotificar);
		if(self.data.GrupoANotificar != '') {
			$('#groupDelete').show();
		}
		$('#descListaANotificar').val(self.data.ListaANotificarDesc);
		$('#listaANotificar').text(self.data.ListaANotificar);
		if(self.data.ListaANotificar != '') {
			$('#listDelete').show();
		}
	},

	getValues() {
		let self = this;

		let comp = true;

		let activa = ($('#activa').prop('checked') == true ? '1' : '0');
		let contry = $('#pais').val();
		if(contry == '') {
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}
		let tiempoEntreEjecuciones = $('#tiempoEntreEjecuciones').val();
		let unidadDeTiempo = $('#unidadDeTiempo').val();

		let usuarioANotificar = $('#usuarioANotificar').text();
		let grupoANotificar = $('#grupoANotificar').text();
		let listaANotificar = $('#listaANotificar').text();

		let mailTo = $('#email').val().trim();
		if(mailTo == '') {
			$('#email').addClass('is-invalid');
			$('[for="email"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#email').removeClass('is-invalid');
			$('[for="email"]').removeClass('is-invalid');
		}
		let asunto = $('#mailHead').val().trim();
		if(asunto == '') {
			$('#mailHead').addClass('is-invalid');
			$('[for="mailHead"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#mailHead').removeClass('is-invalid');
			$('[for="mailHead"]').removeClass('is-invalid');
		}
		let cuerpo = $('#mailBody').val().trim();
		if(cuerpo == '') {
			$('#mailBody').addClass('is-invalid');
			$('[for="mailBody"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#mailBody').removeClass('is-invalid');
			$('[for="mailBody"]').removeClass('is-invalid');
		}

		if(!comp) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let values = {
			id: self.id,
			activa: activa,
			country: contry,
			TiempoEntreEjecuciones: tiempoEntreEjecuciones,
			UnidadDeTiempo: unidadDeTiempo,
			ultimaEjecucion: ultimaEjecucion,
			UsuarioANotificar: usuarioANotificar,
			GrupoANotificar: grupoANotificar,
			ListaANotificar: listaANotificar,
			Archivo: '',
			MailTo: mailTo,
			Asunto: asunto,
			Cuerpo: cuerpo
		};

		self.updateScheduledPayment(values);
	},

	updateScheduledPayment(values) {
		let parameters = {
			id: values.id,
			Activa: values.activa,
			country: values.country,
			TiempoEntreEjecuciones: values.TiempoEntreEjecuciones,
			UnidadDeTiempo: values.UnidadDeTiempo,
			UsuarioANotificar: values.UsuarioANotificar,
			GrupoANotificar: values.GrupoANotificar,
			ListaANotificar: values.ListaANotificar,
			Archivo: values.Archivo,
			MailTo: values.MailTo,
			Asunto: values.Asunto,
			Cuerpo: values.Cuerpo
		};
		ajaxComunCallWithCallback('updateScheduledPayment', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let alertTitle = pf.const.language.RSC1330;
				let alertText = pf.const.language.RSC106;
				let alertBtn = pf.const.language.RSC132;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
					window.location.href = '#!pagos_automatizados';
				});
			}
		});
	},

	clickUser(user) {
		$('#usuarioANotificar').text(user.id);
		$('#descUsuarioANotificar').val(user.email);
		$('#userDelete').show();
	},

	clickGroup(group) {
		$('#grupoANotificar').text(group.groupName);
		$('#descGrupoANotificar').val(group.name);
		$('#groupDelete').show();
	},

	clickList(list) {
		$('#listaANotificar').text(list.id);
		$('#descListaANotificar').val(list.Descripcion);
		$('#listDelete').show();
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};