let PagosAutomatizadosNewController = {
	language: null,

	resetData() {
		let self = this;

		self.language = pf.const.language_table;
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1330 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'btn-save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLanguage();
		self.applyEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		if(countries.length === 1) {
			$('#pais').val(countries[0]);
		}

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.pagosAutomatizados.sharedEvents(self, 'pagosAutomatizadosNewCountry', 'pagosAutomatizadosNew');

		// Guardar pago automatizado
		$('#btn-save').on('click', function() {
			self.getValues();
		});
	},

	getValues() {
		let self = this;

		let comp = true;

		let activa = ($('#activa').prop('checked') == true ? '1' : '0');
		let contry = $('#pais').val();
		if(contry == '') {
			$('#pais').addClass('is-invalid');
			$('#pais-group').addClass('group-invalid');
			$('[for="pais"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#pais').removeClass('is-invalid');
			$('#pais-group').removeClass('group-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}
		let tiempoEntreEjecuciones = $('#tiempoEntreEjecuciones').val();
		let unidadDeTiempo = $('#unidadDeTiempo').val();

		let usuarioANotificar = $('#usuarioANotificar').text();
		let grupoANotificar = $('#grupoANotificar').text();
		let listaANotificar = $('#listaANotificar').text();

		let mailTo = $('#email').val().trim();
		if(mailTo == '') {
			$('#email').addClass('is-invalid');
			$('[for="email"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#email').removeClass('is-invalid');
			$('[for="email"]').removeClass('is-invalid');
		}
		let asunto = $('#mailHead').val().trim();
		if(asunto == '') {
			$('#mailHead').addClass('is-invalid');
			$('[for="mailHead"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#mailHead').removeClass('is-invalid');
			$('[for="mailHead"]').removeClass('is-invalid');
		}
		let cuerpo = $('#mailBody').val().trim();
		if(cuerpo == '') {
			$('#mailBody').addClass('is-invalid');
			$('[for="mailBody"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#mailBody').removeClass('is-invalid');
			$('[for="mailBody"]').removeClass('is-invalid');
		}

		if(!comp) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let values = {
			Activa: activa,
			country: contry,
			TiempoEntreEjecuciones: tiempoEntreEjecuciones,
			UnidadDeTiempo: unidadDeTiempo,
			UsuarioANotificar: usuarioANotificar,
			GrupoANotificar: grupoANotificar,
			ListaANotificar: listaANotificar,
			Archivo: '',
			MailTo: mailTo,
			Asunto: asunto,
			Cuerpo: cuerpo
		};

		self.setScheduledPayment(values);
	},

	setScheduledPayment(values) {
		let parameters = {
			Activa: values.activa,
			country: values.country,
			TiempoEntreEjecuciones: values.TiempoEntreEjecuciones,
			UnidadDeTiempo: values.UnidadDeTiempo,
			UsuarioANotificar: values.UsuarioANotificar,
			GrupoANotificar: values.GrupoANotificar,
			ListaANotificar: values.ListaANotificar,
			Archivo: values.Archivo,
			MailTo: values.MailTo,
			Asunto: values.Asunto,
			Cuerpo: values.Cuerpo
		};
		ajaxComunCallWithCallback('setScheduledPayment', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let alertTitle = pf.const.language.RSC1330;
				let alertText = pf.const.language.RSC106;
				let alertBtn = pf.const.language.RSC132;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
					window.location.href = '#!pagos_automatizados';
				});
			}
		});
	},

	clickUser(user) {
		$('#usuarioANotificar').text(user.id);
		$('#descUsuarioANotificar').val(user.email);
		$('#userDelete').show();
	},

	clickGroup(group) {
		$('#grupoANotificar').text(group.groupName);
		$('#descGrupoANotificar').val(group.name);
		$('#groupDelete').show();
	},

	clickList(list) {
		$('#listaANotificar').text(list.id);
		$('#descListaANotificar').val(list.Descripcion);
		$('#listDelete').show();
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};