let ProductosEditController = {
	user: null,
	language: null,
	idProduct: null,
	imgName: null,
	template: '',
	eventType: null,
	data: null,
	dataImage: null,
	dataType: null,
	type: null,

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.idProduct = atob(sessionStorage.getItem('idProduct'));
		self.imgName = null;
		self.template = '';
		self.eventType = null;
		self.data = null;
		self.dataImage = null;
		self.dataType = null;
		self.type = null;
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Ocultar select de plantillas
		$('#templateContainer').hide();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2068);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Ocultar cubo de basura
		$('#countryDelete').hide();

		self.loadLang();

		let parameters = {
			idProduct: self.idProduct
		};
		ajaxComunCallWithCallback('getProductsAnaquelByID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				self.renderForm();
			}
		});

		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.producto.sharedEvents(self, 'productsEdit');

		// Guardar producto
		$('#save').on('click', function() {
			self.updateProductsAnaquel();
		});
	},

	clickEvents(data) {
		let self = this;

		switch(self.eventType) {
			case 'searchCountry':
				$('#country').val(data.isocode);
				$('#countryDelete').show();
			break;
			case 'searchtemplate':
				self.template = data.idTemplate;
				$('#template').val(data.name);
			break;
		}
	},

	renderForm() {
		let self = this;

		self.imgName = self.data[0].image;
		self.type = self.data[0].type;
		let src = stcm.const.downloads + 'products/default_img/' + self.imgName;
		$('#imgProductChosen').attr('src', src);
		// Nombre
		$('#name').val(self.data[0].name);
		// País
		if(self.data[0].country != '') {
			// Mostrar cubo de basura
			$('#countryDelete').show();
		}
		$('#country').val(self.data[0].country);
		// Descripción
		$('#description').val(self.data[0].description);
		// Clase
		$('#survey').prop('checked', (self.data[0].isSurvey == '1' ? true : false));
		if(self.data[0].isSurvey == '1') {
			$('#templateContainer').show();
			self.template = self.data[0].template;
			$('#template').val(self.data[0].templateName);
		}
		$('#videocall').prop('checked', (self.data[0].isVideocall == '1' ? true : false));
		$('#passive').prop('checked', (self.data[0].isPassiveTracking == '1' ? true : false));
	},

	updateProductsAnaquel() {
		let self = this;

		// Imagen
		let image = false;
		if(self.imgName === null) {
			image = true;
		}
		// Nombre
		let name = $('#name').val().trim();
		if(name === '') {
			$('#name').addClass('is-invalid');
			$('[for="name"]').addClass('is-invalid');
		} else {
			$('#name').removeClass('is-invalid');
			$('[for="name"]').removeClass('is-invalid');
		}
		// Descripción
		let description = $('#description').val().trim();
		if(description === '') {
			$('#description').addClass('is-invalid');
			$('[for="description"]').addClass('is-invalid');
		} else {
			$('#description').removeClass('is-invalid');
			$('[for="description"]').removeClass('is-invalid');
		}
		// Clase
		let isSurvey = ($('#survey').prop('checked') ? '1' : '0');
		let isVideocall = ($('#videocall').prop('checked') ? '1' : '0');
		let isPassiveTracking = ($('#passive').prop('checked') ? '1' : '0');

		let warning = false;
		let warningText = '';
		if(image) {
			warning = true;
			warningText += pf.const.language.RSC2073;
		}
		if(name === '' || description === '') {
			warning = true;
			warningText += '<br>' + pf.const.language.RSC101;
		}
		if(isSurvey === '0' && isVideocall === '0' && isPassiveTracking === '0') {
			warning = true;
			warningText += '<br>' + pf.const.language.RSC2074;
		}
		if(isSurvey == '1' && self.template == '') {
			warning = true;
			warningText += '<br>' + pf.const.language.RSC2090;
			$('#template').addClass('is-invalid');
			$('[for="template"]').addClass('is-invalid');
		} else {
			$('#template').removeClass('is-invalid');
			$('[for="template"]').removeClass('is-invalid');
		}

		if(warning) {
			let alertTitle = pf.const.language.RSC2048;
			pf.utils.showInfoDialog(alertTitle, warningText);
			return false;
		}

		let country = $('#country').val();

		let parameters = {
			idProduct: self.idProduct,
			name: name,
			description: description,
			image: self.imgName,
			template: self.template,
			country: country,
			isSurvey: isSurvey,
			isPassiveTracking: isPassiveTracking,
			isVideocall: isVideocall,
			type: self.type
		};
		ajaxComunCallWithCallback('updateProductsAnaquel', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2048;
				let successContent = pf.const.language.RSC2077;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!productos';
			}
		});
	}
};