stcmbackend.producto = {
	sharedEvents(self, modal) {
		$('#back').on('click', function() {
			window.location.href = '#!productos';
		});

		// Visualizar imágenes para portada
		$('#viewImages').on('click', function() {
			ajaxComunCallWithCallback('viewImagesProducts', {}, function(ajaxReturn) {
				if(ajaxReturn) {
					self.dataImage = ajaxReturn.result;

					stcmbackend.producto.renderDataImage(self);
				}
			});
		});

		// País
		let countryModal = new TableCountries(0, modal);
		$('#searchCountry').off().on('click', function() {
			self.eventType = 'searchCountry';
			countryModal.setEvents();
		});

		// Limpiar País
		$('#countryDelete').on('click', function() {
			$('#country').val('');
			$('#countryDelete').hide();
		});

		// Control de tipo
		$('.productsType').on('click', function() {
			let checkedSurvey = $('#survey').prop('checked');
			let checkedVideocall = $('#videocall').prop('checked');
			let checkedPassive = $('#passive').prop('checked');
			if(checkedSurvey) {
				$('#templateContainer').show();
			} else {
				self.template = '';
				$('#templateContainer').hide();
				$('#template').val('');
			}

			// Petición de tipos
			let parameters = {
				survey: (checkedSurvey ? '1' : '0'),
				isVideocall: (checkedVideocall ? '1' : '0'),
				isPassiveTracking: (checkedPassive ? '1' : '0')
			};
			ajaxComunCallWithCallback('getTipoMisionByType', parameters, function(ajaxReturn) {
				if(ajaxReturn) {
					self.dataType = ajaxReturn.result;

					stcmbackend.producto.renderDataType(self);
				}
			});
		});

		// Plantilla
		let templateModal = new TableTemplates(modal);
		$('#searchtemplate').off().on('click', function() {
			self.eventType = 'searchtemplate';
			templateModal.setEvents();
		});
	},

	renderDataImage(self) {
		let galleryElements = `
			<div class="d-flex flex-row flex-wrap">
		`;

		let size = self.dataImage.length;
		for(let i = 0; i < size; i++) {
			// Saltar '.' y '..'
			if(self.dataImage[i] == '.' || self.dataImage[i] == '..') {
				continue;
			}

			let srcImg = stcm.const.downloads + 'products/default_img/' + self.dataImage[i];
			galleryElements += `
				<div class="p-2 wi-20per">
					<div class="productImage c-pointer border" data-imgname="${self.dataImage[i]}">
						<img src="${srcImg}" class="w-100">
					</div>
				</div>
			`;
		}

		galleryElements += `
			</div>
		`;

		$('#bodyPictures').html(galleryElements);

		stcmbackend.producto.dataImageEvents(self);
	},

	dataImageEvents(self) {
		// Seleccionar imágen
		$('.productImage').on('click', function() {
			self.imgName = $(this).data('imgname');
			let src = $(this).find('img').attr('src');

			$('#imgProductChosen').attr('src', src);

			$('#closePictures').trigger('click');
		});
	},

	renderDataType(self) {
		let size = self.dataType.length;
		if(size == 1) {
			self.type = self.dataType[0].idTipoMision;
		} else {
			$('#missionTypeTable').modal({backdrop: 'static', keyboard: false});
			$('#missionTypeTable').modal('show');

			let table = `
				<table id="tableMissionType" class="table table-hover tr-pointer tRegs">
					<thead>
						<tr>
							<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
							<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						</tr>
					</thead>

					<thead class="filtersTypes">
						<tr>
							<td>nombre</td>
							<td>descripción</td>
						</tr>
					</thead>

					<tbody>
			`;

			for(let i = 0; i < size; i++) {
				table += `
					<tr class="c-pointer" data-id="${self.dataType[i].idTipoMision}">
						<td title="${self.dataType[i].idTipoMision}">${self.dataType[i].idTipoMision}</td>
						<td title="${self.dataType[i].Descripcion}">${self.dataType[i].Descripcion}</td>
					</tr>
				`;
			}

			table += `
					</tbody>
				</table>
			`;

			$('#containerMissionType').html(table);

			// Setup - add a text input to each footer cell
			$('#tableMissionType .filtersTypes td').each(function() {
				let value = `<input type="text" class="form-control form-control-sm">`;

				$(this).html(value);
			});

			let tableTypes = $('#tableMissionType').DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				autoWidth: false,
				aaSorting: []
			});

			setTimeout(function() {
				tableTypes.columns.adjust();
			}, 200);

			// Ocultar botones de tabla
			hideTableButtons('tableMissionType');

			// Apply the search
			applyTheSearch(tableTypes, 'filtersTypes');

			// Detectar click
			$('#tableMissionType tbody').off().on('click', 'tr', function() {
				self.type = $(this).data('id');

				if(self.type == undefined) {
					self.type = null;
					$('.productsType').prop('checked', false);
				}

				$('#missionTypeTable').modal('hide');
			});
		}
	}
};