stcmbackend.articulos = {
	sharedEvents(self) {
		// Volver a Artículos
		$('#back').on('click', function() {
			window.location.href = '#!articulos_catalogo';
		});

		// Carga de imagen principal
		$('#mainPictureIMG').on('click', function() {
			$('#mainPicture').trigger('click');
		});
		$('#mainPicture').change(function(evt) {
			let file = evt.target.files[0];
			if(file.size > self.maxSize) {
				let alertTitle = pf.const.language.RSC1909;
				let alertText = pf.const.language.RSC1337;
				pf.utils.showInfoDialog(alertTitle, alertText);
			} else {
				self.mainPicture = file;
				let src = URL.createObjectURL(evt.target.files[0]);
				$('#btn_mainPicture').show();
				$('#mainPictureIMG').attr('src', src);
				$('#morePictures').show();
			}
		});
	},

	tableCountriesEnabledEvents(self, initialSwitch = false) {
		// Input de valor
		$('.valueInput').off().on('blur', function() {
			let index = $(this).data('index');
			let value = $(this).val();

			self.countriesArticles[index].value = value;
			$('#value' + index).text(value);
			$('#valueInput' + index).attr('title', value);
		});

		// Select de moneda
		$('.coinSelect').off().on('change', function() {
			let index = $(this).data('index');
			let value = $(this).val();

			self.countriesArticles[index].currency = value;
		});

		// Input de cantidad
		$('.amountInput').off().on('blur', function() {
			let index = $(this).data('index');
			let value = $(this).val();

			self.countriesArticles[index].amount = value;
			$('#amount' + index).text(value);
			$('#amountInput' + index).attr('title', value);
		});

		if(initialSwitch) {
			// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
			// Comprobación inicial
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			} 
		}

		// Checkbox de activo
		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);

			for(obj in self.countriesArticles) {
				if(this.checked) {
					self.countriesArticles[obj].enabled = 1;
				} else {
					self.countriesArticles[obj].enabled = 0;
				}
			}
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			let index = $(this).data('index');
			if(this.checked) {
				self.countriesArticles[index].enabled = 1;
			} else {
				self.countriesArticles[index].enabled = 0;
			}

			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}
		});
	}
};