let StepByStepSurveyController = {
	config: null,
	url: null,
	stampMission: null,
	idMisionProduct: null,
	sid: null,
	misionObjective: null,
	descMisionObjective: null,

	resetData() {
		let self = this;

		self.config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.url = null;
		self.stampMission = sessionStorage.getItem('stampMissionSBS');
		self.idMisionProduct = sessionStorage.getItem('idMisionSBS');
		self.sid = sessionStorage.getItem('surveySBS');
		self.misionObjective = sessionStorage.getItem('misionObjectiveSBS');
		self.descMisionObjective = sessionStorage.getItem('descMisionObjectiveSBS');
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Recogida de id de encuesta y activación de botón de siguiente
		window.onmessage = (event) => {
			let data = event.data;
			if(data.action == 'resultStepByStepSurvey') {
				self.sid = data.value;
				sessionStorage.setItem('surveySBS', self.sid);
				$('#nextSBS').removeClass('disabledSBS');
				$('#nextSBS').addClass('c-pointer');
				self.setMisionObjetivo();
			}
		}

		// Activar botón de siguiente su ya hay encuesta seleccionad
		if(self.sid != '') {
			$('#nextSBS').removeClass('disabledSBS');
			$('#nextSBS').addClass('c-pointer');
		}

		// Reducción de Header
		headerSectionHeight(0);

		self.loadLang();
		self.applyEvents();

		// Valores de configuración
		if(self.config.URLEncuestasSession != '') {
			self.url = self.config.URLEncuestasSession + '&s=1&name=' + sessionStorage.getItem('nameProjectSBS');
		} else {
			if(self.config.URLEncuestas == '' || self.config.URLEncuestas == undefined || self.config.URLEncuestas == null) {
				let warningTitle = pf.const.language.RSC61;
				let warningContent = pf.const.language.RSC993;
				pf.utils.showInfoDialog(warningTitle, warningContent);
				return;
			}
			self.url = self.config.URLEncuestas + 'index.php/admin';
		}

		// OPCIÓN para pruebas en local
		//self.url = 'https://surveystxus.sociallabs.biz//admin/authentication/sa/login?session=P2w5ncgyq7Wes3YAPvPVG6N2WRs5U8KsBaXmGHvLTyHkDuuBY41BSB%2FXzbhrThrd&s=1&name=' + sessionStorage.getItem('nameProjectSBS');

		self.printIframe();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// Títulos comunes
		StepByStepSharedController.commonTitles();
	},

	applyEvents() {
		let self = this;

		// Volver a Producto / Misión
		$('#backSBS').off().on('click', function() {
			window.location.href = '#!step_by_step_mission_edit';
		});

		// Ir a Producto / Criterios
		$('#nextSBS').off().on('click', function() {
			if(self.sid != '') {
				// Control nuevo / editar
				if(sessionStorage['criterionSBS'] == '1') {
					window.location.href = '#!step_by_step_criterion_edit';
				} else {
					window.location.href = '#!step_by_step_criterion_new';
				}
			}
		});
	},

	setMisionObjetivo() {
		let self = this;

		let parameters = {
			idmision: self.idMisionProduct,
			idEncuesta: self.sid,
			descencuesta: self.idMisionProduct,
			objetivo: self.misionObjective,
			descobjetivo: self.descMisionObjective,
			stampMission: self.stampMission
		};
		ajaxComunCallWithCallback('setMisionObjetivoAndUpdateSurveyExpiration', parameters, function() {
			//
		});
	},

	printIframe() {
		let self = this;

		// En caso de editar encuesta
		if(self.sid != '') {
			self.url = self.config.URLEncuestas + 'index.php/admin/survey/sa/view/surveyid/' + self.sid;
		}

		self.renderIframe();
	},

	renderIframe() {
		let self = this;

		let iframe = `
			<div class="ml-1">
				<iframe id="sIframe" src="${self.url}" class="d-none w-100 he-cal-100vh-n188 border-0" allowfullscreen></iframe>
				<div id="surveyStepByStepLoader" class="animated fadeIn loaderspinner loadingMessageIframe">
					<div id="loader" class="color-loader"></div>
				</div>
			</div>
		`;

		$('#iframeSurveysSBS').html(iframe);

		self.bindIframeLoader();
	},

	bindIframeLoader() {
		let self = this;

		$('#sIframe').on('load', function() {
			$('#sIframe')[0].contentWindow.postMessage({
				action: 'stepByStepSurvey'
			}, '*');

			self.finishLoading();
		});
	},

	finishLoading() {
		removeLoader();
		$('.loadingMessageIframe').remove();
		$('#sIframe').removeClass('d-none');
	}
};