class TableCustomers {
	constructor(actions) {
		this.actionsTable = actions;
		this.data = null;
	}

	setEvents() {
		let self = this;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllClientes', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC1540}">${pf.const.language.RSC1540}</th>
						<th scope="col" title="${pf.const.language.RSC1541}">${pf.const.language.RSC1541}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					</tr>
				</thead>

				<thead class="filtersCustomers">
					<tr>
						<td>razonSocial</td>
						<td>nombreComercial</td>
						<td>country</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr class="trSelected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].razonSocial}">${self.data[i].razonSocial}</td>
					<td class="text-truncate" title="${self.data[i].nombreComercial}">${self.data[i].nombreComercial}</td>
					<td class="text-truncate" title="${self.data[i].country}">${self.data[i].country}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC2363);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersCustomers td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableTenant = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '60px', targets: 2}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableTenant.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableTenant, 'filtersCustomers');

		// Detectar click
		$('.trSelected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	}

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'newMissionCustomer':
				MisionesNewController.clickEvents(self.data[id]);
				break;
			case 'editMissionCustomer':
				MisionesEditController.clickEvents(self.data[id]);
				break;
			case 'newAdministradorCustomer':
				AdministradoresNuevoController.clickEvents(self.data[id]);
				break;
			case 'editAdministradorCustomer':
				AdministradoresEditarController.clickEvents(self.data[id]);
				break;
			case 'StepByStepMissionNewController':
				StepByStepMissionNewController.clickEvents(self.data[id]);
				break;
			case 'StepByStepMissionEditController':
				StepByStepMissionEditController.clickEvents(self.data[id]);
				break;
		}
	}
}