let TableGroupsUser = {
	data: null,
	type: null,
	idRender: null,
	isAdmin: null,

	resetData() {
		let self = this;

		self.data = null;
		self.type = null;
		self.idRender = null;
		self.isAdmin = null;
	},

	setEvents(data, id, type, isAdmin = 0) {
		let self = this;
		self.resetData();

		self.data = data;
		self.idRender = id;
		self.type = type;
		self.isAdmin = isAdmin;
		self.renderTable();
	},

	renderTable() {
		let self = this;

		let contentTable = '';
		let colRemove = '';
		let colRemoveLabel = '';
		if(self.isAdmin == 0) {
			colRemove = '<th scope="col"></th>';
			colRemoveLabel = '<td>trash</td>';
		}
		let idTable = 'tableGroups';
		if(self.isAdmin == 1) {
			idTable = 'tableGroupsAdmin';
		}

		contentTable += `
			<table id="${idTable}" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col">${pf.const.language.RSC123}</th>
						<th scope="col">${pf.const.language.RSC163}</th>
						${colRemove}
					</tr>
				</thead>

				<thead class="filters">
					<tr>
						<td>nameVisual</td>
						<td>name</td>
						${colRemoveLabel}
					</tr>
				</thead>

				<tbody>
		`;

		if(self.data) {
			$.each(self.data, function(i, elem) {
				// Comprovar si es listado de Admin
				let colRemove = '';
				if(self.isAdmin == 0) {
					colRemove = `
						<td class="remove-member text-center" data-id="${i}">
							<span class="c-pointer circle-container" data-id="${i}">
								${stcmbackend.svg.trash}
							</span>
						</td>
					`;
				}

				if(self.data[i].role != 'admin' && self.isAdmin == 1) {
					contentTable += '';
				} else {
					contentTable += `
						<tr class="user_selected c-pointer" data-id="${i}">
							<td class="text-truncate" title="${self.data[i].nameVisual}">${self.data[i].nameVisual}</td>
							<td class="text-truncate" title="${self.data[i].name}">${self.data[i].name}</td>
							${colRemove}
						</tr>
					`;
				}
			});
		}

		contentTable += `
				</tbody>
			</table>
		`;

		$('#' + self.idRender).html(contentTable);

		// Setup - add a text input to each footer cell
		$('#' + idTable + ' .filters td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'trash') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableUsers = '';

		if(self.isAdmin == 0) {
			tableUsers = $('#' + idTable).DataTable({
				language: pf.const.language_table,
				retrieve: true,
				pageLength: 25,
				autoWidth: false,
				columnDefs: [
					{width: '30px', orderable: false, targets: 2}
				],
				dom: 'Bfrtip',
				buttons: [{
					extend: 'excelHtml5',
					text: pf.const.language.RSC129,
					className: 'd-none',
					title: pf.const.language.RSC6,
					customize(xlsx) {
						dataTablesExcelCustomize(xlsx);
					}
				}],
				aaSorting: []
			});
		} else {
			tableUsers = $('#' + idTable).DataTable({
				language: pf.const.language_table,
				retrieve: true,
				pageLength: 25,
				autoWidth: false,
				dom: 'Bfrtip',
				buttons: [{
					extend: 'excelHtml5',
					text: pf.const.language.RSC129,
					className: 'd-none',
					title: pf.const.language.RSC311,
					customize(xlsx) {
						dataTablesExcelCustomize(xlsx);
					}
				}],
				aaSorting: []
			});
		}

		// Ocultar botones de tabla
		hideTableButtons(idTable);

		// Apply the search
		applyTheSearch(tableUsers, 'filters');

		$('.remove-member').off().on('click', function() {
			let id = $(this).data('id');

			self.eventsTable(id);
		});

		// Exportar tabla grupos miembro
		$('#exportGroup').off().on('click', function() {
			$('#divGroupsTable .buttons-excel').trigger('click');
		});

		// Exportar tabla grupos administrador
		$('#exportGroupAdmin').off().on('click', function() {
			$('#divGroupsTableAdmin .buttons-excel').trigger('click');
		});
	},

	eventsTable(id) {
		let self = this;

		switch(self.type) {
			case 'editUsers':
				UsuariosEditarController.clickEvents(id, 'removeGroup');
				break;
			case 'newUser':
				UsuariosNuevoController.clickEvents(id, 'removeGroup');
				break;
		}
	}
};