class TableHtmlRoles {
	constructor() {
		this.data = null;
		this.excel = false;
		this.checked = null;
	}

	setEvents() {
		let self = this;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	getData() {
		return this.data;
	}

	getRoles() {
		let self = this;

		let response = [];
		$('#tableHtml .custom-switch input').each(function() {
			if($(this).data('id') != 'all') {
				let isCheck = $(this).prop('checked');
				if(isCheck) {
					response.push(self.data[$(this).data('id')].role);
				}
			}
		});
		return response;
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllRoles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				if(Array.isArray(ajaxReturn.result)) {
					self.data = ajaxReturn.result;
				} else {
					self.data = [];
				}

				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableHtml" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col">
							Id
							<span class="float-right">${pf.const.language.RSC278}:</span>
						</th>
						<th scope="col">
							<div class="custom-control custom-switch">
								<input id="allSwitchs" type="checkbox" class="custom-control-input" data-id="all">
								<label for="allSwitchs" class="custom-control-label c-pointer"></label>
							</div>
						</th>
					</tr>
				</thead>

				<tbody>
		`;

		let allChecked = [];
		let control = true;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			let isCheck = '';

			if(self.checked) {
				for(let j = 0; j < self.checked.length; j++) {
					if(self.checked[j] == self.data[i].role) {
						isCheck = 'checked';
					}
				}

				if(isCheck == '') {
					allChecked.push(0);
				} else {
					allChecked.push(1);
				}
			} else {
				control = false;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-truncate" title="${self.data[i].role}">${(self.data[i].role != '' ? self.data[i].role : `<center>-</center>`)}</td>
					<td class="pl-0">
						<div class="custom-control custom-switch">
							<input id="role_${i}" type="checkbox" class="custom-control-input uSwitch" data-id="${i}" ${isCheck}>
							<label for="role_${i}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#resultTable').html(table);

		// Comprobación de checked
		for(let i = 0; i < allChecked.length; i++) {
			if(allChecked[i] == 0) {
				control = false;
				break;
			}
		}

		if(control) {
			$('#allSwitchs').prop('checked', true);
		}

		let dataTable = $('#tableHtml').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			searching: false,
			autoWidth: false,
			columnDefs: [
				{width: '30px', orderable: false, targets: 1}
			]
		});

		// Ocultar botones de tabla
		hideTableButtons('tableHtml');

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		// Comprobación inicial
		if($('.uSwitch').length == $('.uSwitch:checked').length) {
			$('#allSwitchs').prop('checked', true);
		} else {
			$('#allSwitchs').prop('checked', false);
		}

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}
		});
	}
}