let tableImport = {
	data: null,
	idRender: null,

	setEvents(data, id) {
		let self = this;

		self.data = data;
		self.idRender = id;
		self.renderTable();
	},

	renderTable() {
		let self = this;

		let gdpr = sessionStorage['STCMBackEnd:GDPR'];

		let nameSurnameHead = `
			<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
			<th scope="col" title="${pf.const.language.RSC1626}">${pf.const.language.RSC1626}</th>
			<th scope="col" title="${pf.const.language.RSC1627}">${pf.const.language.RSC1627}</th>
		`;
		let nameSurnameFilter = `
			<td>nombre</td>
			<td>apellido1</td>
			<td>apellido2</td>
		`;

		// Control GDPR
		if(gdpr == '1') {
			nameSurnameHead = '';
			nameSurnameFilter = '';
		}

		let contentTable = '';
		contentTable += `
			<table id="tableUsersImport" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC136}">${pf.const.language.RSC136}</th>
						${nameSurnameHead}
						<th scope="col" title="${pf.const.language.RSC134}">${pf.const.language.RSC134}</th>
						<th scope="col" title="${pf.const.language.RSC277}">${pf.const.language.RSC277}</th>
						<th scope="col" title="${pf.const.language.RSC71}">${pf.const.language.RSC71}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC552}">${pf.const.language.RSC552}</th>
						<th scope="col" title="${pf.const.language.RSC560}">${pf.const.language.RSC560}</th>
					</tr>
				</thead>

				<thead class="filters">
					<tr>
						<td>email</td>
						${nameSurnameFilter}
						<td>perfil</td>
						<td>role</td>
						<td>password</td>
						<td>pais</td>
						<td>idioma</td>
						<td>consejero</td>
					</tr>
				</thead>
			<tbody>
		`;

		if(self.data) {
			$.each(self.data, function(i, elem) {
				let nameSurnameBody = `
					<td class="text-truncate" title="${self.data[i].nombre}">${(self.data[i].nombre ? self.data[i].nombre : '-')}</td>
					<td class="text-truncate" title="${self.data[i].apellido1}">${(self.data[i].apellido1 ? self.data[i].apellido1 : '-')}</td>
					<td class="text-truncate" title="${self.data[i].apellido2}">${(self.data[i].apellido2 ? self.data[i].apellido2 : '-')}</td>
				`;

				// Control GDPR
				if(gdpr == '1') {
					nameSurnameBody = '';
				}

				contentTable += `
					<tr class="user_selected c-pointer" data-id="${i}">
						<td class="text-truncate" title="${self.data[i].email}">${(self.data[i].email ? self.data[i].email : '-')}</td>
						${nameSurnameBody}
						<td class="text-truncate" title="${self.data[i].perfil}">${(self.data[i].perfil ? self.data[i].perfil : '-')}</td>
						<td class="text-truncate" title="${self.data[i].role}">${(self.data[i].role ? self.data[i].role : '-')}</td>
						<td class="text-truncate" title="${self.data[i].password}">${(self.data[i].password ? self.data[i].password : '-')}</td>
						<td class="text-truncate" title="${self.data[i].pais}">${(self.data[i].pais ? self.data[i].pais : '-')}</td>
						<td class="text-truncate" title="${self.data[i].idioma}">${(self.data[i].pais ? self.data[i].idioma : '-')}</td>
						<td class="text-center" title="${self.data[i].consejero}">
							<input type="checkbox" disabled ${(self.data[i].consejero == '1' ? 'checked' : '')}>
						</td>
					</tr>
				`;
			})
		}

		contentTable += `
				</tbody>
			</table>
		`;

		$('#' + self.idRender).html(contentTable);

		// Setup - add a text input to each footer cell
		$('#tableUsersImport .filters td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'trash') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableUsers = $('#tableUsersImport').DataTable({
			language: pf.const.language_table,
			retrieve: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableUsersImport');

		// Apply the search
		applyTheSearch(tableUsers, 'filters');
	}
};