let tableMembers = {
	data: null,
	type: null,
	idRender: null,

	setEvents(data, id, type) {
		let self = this;

		// Tipo seleccion
		self.data = data;
		self.idRender = id;
		self.type = type;
		self.renderTable();
	},

	renderTable() {
		let self = this;

		let gdpr = sessionStorage['STCMBackEnd:GDPR'];

		let nameSurnameHead = `<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>`;
		let nameSurnameFilter = `<td>nameUser</td>`;

		// Control GDPR
		if(gdpr == '1') {
			nameSurnameHead = '';
			nameSurnameFilter = '';
		}

		let contentTable = '';
		contentTable += `
			<table id="tableMembers" class="table table-hover tRegs">
				<thead>
					<tr>
						${nameSurnameHead}
						<th scope="col" title="${pf.const.language.RSC136}">${pf.const.language.RSC136}</th>
						<th scope="col"></th>
					</tr>
				</thead>

				<thead class="filters">
					<tr>
						${nameSurnameFilter}
						<td>email</td>
						<td>trash</td>
					</tr>
				</thead>

				<tbody>
		`;

		if(self.data) {
			$.each(self.data, function(i, elem) {
				let surname1 = '';
				if(self.data[i].userApellidos && self.data[i].userApellidos != 'null') {
					surname1 = self.data[i].userApellidos 
				}

				let surname2 = '';
				if(self.data[i].userApellidos2 && self.data[i].userApellidos2 != 'null') {
					surname2 = self.data[i].userApellidos2 
				}

				let nameComplet = self.data[i].nameUser + ' ' + surname1 + ' ' + surname2;

				let nameSurnameBody = `<td class="text-truncate" title="${nameComplet}">${nameComplet}</td>`;

				// Control GDPR
				if(gdpr == '1') {
					nameSurnameBody = '';
				}

				contentTable += `
					<tr class="user_selected c-pointer" data-id="${i}">
						${nameSurnameBody}
						<td class="text-truncate" title="${self.data[i].email}">${self.data[i].email}</td>
						<td class="remove-member text-center" data-id="${i}">
							<span class="c-pointer circle-container" data-id="${i}">
								${stcmbackend.svg.trash}
							</span>
						</td>
					</tr>
				`;
			})
		}

		contentTable += `
				</tbody>
			</table>
		`;

		$('#' + self.idRender).html(contentTable);

		// Setup - add a text input to each footer cell
		$('#tableMembers .filters td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'trash') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let columnDefs = [
			{width: '30px', orderable: false, targets: 2}
		];

		// Control GDPR
		if(gdpr == '1') {
			columnDefs = [
				{width: '30px', orderable: false, targets: 1}
			];
		}

		let tableUsers = $('#tableMembers').DataTable({
			language: pf.const.language_table,
			retrieve: true,
			pageLength: 25,
			autoWidth: false,
			columnDefs: columnDefs,
			aaSorting: [],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: '',
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		// Ocultar botones de tabla
		hideTableButtons('tableMembers');

		// Apply the search
		applyTheSearch(tableUsers, 'filters');

		// Exportar tabla
		$('#exportInner').off().on('click', function() {
			if(self.data == null || self.data.length == 0) {
				window.location = stcm.const.downloads + 'layout_difusion.xls';
			} else {
				$('#tableMembersUsers .buttons-excel').trigger('click');
			}
		});

		$('.remove-member').off().on('click', function() {
			let id = $(this).data('id');

			self.eventsTable(id);
		});

		$('#tableMembersUsers').on('draw.dt', function() {
			$('.remove-member').off().on('click', function() {
				let id = $(this).data('id');

				self.eventsTable(id);
			});
		});
	},

	eventsTable(id) {
		let self = this;

		switch(self.type) {
			case 'newGroups':
				GruposNuevoController.clickEvents(id, 'removeMember');
				break;
			case 'editGroups':
				GruposEditarController.clickEvents(id, 'removeMember');
				break;
			case 'newList':
				DifusionNewController.clickEvents(id, 'removeMember');
				break;
			case 'editList':
				DifusionEditController.clickEvents(id, 'removeMember');
				break;
		}
	}
};