let tablePerfiles = {
	data: null,
	actionsTable: null,

	setEvents(actions) {
		let self = this;

		// Acciones tabla
		self.actionsTable = actions;
		self.data=[];

		self.requestData();
	},

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getProfiles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				// Búsqueda de perfiles activos y creación de select
				let size = ajaxReturn.result.length;
				if(!Array.isArray(ajaxReturn.result)) {
					self.data = [];
				} else {
					for(let i = 0; i < size; i++) {
						if(ajaxReturn.result[i].enabled == 1) {
							self.data.push(ajaxReturn.result[i]);
						}
					}
				}

				if(self.data) self.renderTable();
			}
		});
	},

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer">
				<thead>
					<tr>
						<th scope="col" title="id">id</th>
						<th scope="col" title="${pf.const.language.RSC134}">${pf.const.language.RSC134}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>id</td>
						<td>perfil</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr class="rol_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td title="${self.data[i].id}">${self.data[i].id}</td>
					<td title="${self.data[i].descripcion}">${self.data[i].descripcion}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC553);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersUser td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableUsers = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');

		// Detectar click
		$('.rol_selected').click(function() {
			self.eventsTable($(this).data('id'));
		})
	},

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'formularioRegistro':
				FormularioRegistroController.clickEvents(self.data[id]);
				break;
			case 'usersNew':
				UsuariosNuevoController.clickEvents(self.data[id]);
				break;
			case 'usersEdit':
				UsuariosEditarController.clickEvents(self.data[id]);
				break;
		}
	}
};