class TableProjects {
	constructor() {
		this.data = null;
		this.idmision = null;
		this.mision = null;
		this.isReport = false;
	}

	setEvents(mision, isReport) {
		let self = this;

		self.mision = mision;
		self.idmision = mision.idmision;
		self.isReport = isReport;
		self.requestData();
	}

	requestData() {
		let self = this;

		clearGeneralModal();

		let parameters = {
			idmision: self.idmision
		};
		ajaxComunCallWithCallback('getProjectsByMision', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				if(self.data.length == 1) {
					if(self.isReport) {
						// Toda la información del proyecto
						MisionesController.getMision(self.data[0]);
					} else {
						$('#closeUser').trigger('click');
						let vMision = self.mision;
						vMision.textofinmision = '';
						vMision.textofinmisioncupo = '';
						vMision.textoiniciomision = '';
						vMision.textomisionko = '';
						vMision.textomisionkoautonocumplimiento = '';
						vMision.textomisionok = '';
						vMision.textovalidacion = '';
						let vProject = self.data[0];
						vMision.idProject = vProject.id;
						let params = {
							mision: vMision,
							project: vProject
						}

						sessionStorage.setItem('STCMBackEnd:validate', btoa(JSON.stringify(params)));
						window.location.href = '#!proyectos_validar';
					}
				} else {
					$('#modalContainer').modal('show');
					self.renderTable();
				}
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC143}">${pf.const.language.RSC143}</th>
						<th scope="col" title="${pf.const.language.RSC144}">${pf.const.language.RSC144}</th>
						<th scope="col" title="${pf.const.language.RSC113}">${pf.const.language.RSC113}</th>
					</tr>
				</thead>

				<thead class="filtersProjects">
					<tr>
						<td>name</td>
						<td>leader</td>
						<td>client</td>
						<td>creationDate</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr id="id-${self.data[i].id}" class="c-pointer" data-id="${i}">
					<td class="text-truncate" title="${self.data[i].NombreProyecto}">${self.data[i].NombreProyecto}</td>
					<td class="text-truncate" title="${self.data[i].LiderProyecto}">${self.data[i].LiderProyecto}</td>
					<td class="text-truncate" title="${self.data[i].ClienteInterno}">${self.data[i].ClienteInterno}</td>
					<td class="text-truncate" title="${self.data[i].FechaDeAlta}">${self.data[i].FechaDeAlta}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC10);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersProjects td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableUsers = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '200px', targets: 3}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableUsers, 'filtersProjects');

		// Detectar click
		$('#tableModal tbody').off().on('click', 'tr', function() {
			self.eventsTable($(this).data('id'));
			$('#closeUser').trigger('click');
		});
	}

	eventsTable(id) {
		let self = this;

		if(self.isReport) {
			// Toda la información del proyecto
			MisionesController.getMision(self.data[id]);
		} else {
			let vMision = self.mision;
			let vProject = self.data[id];
			vMision.idProject = vProject.id;
			let params = {
				mision: vMision,
				project: vProject
			}

			sessionStorage.setItem('STCMBackEnd:validate', btoa(JSON.stringify(params)));
			window.location.href = '#!proyectos_validar';
		}
	}
}