class TableStartMissions {
	constructor(actions) {
		this.actionsTable = actions;
		this.data = null;
	}

	setEvents() {
		let self = this;

		clearGeneralModal();

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllMisionesDeInicio', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tRegs" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC26}">${pf.const.language.RSC26}</th>
						<th scope="col" title="${pf.const.language.RSC330}">${pf.const.language.RSC330}</th>
						<th scope="col" title="${pf.const.language.RSC145}">${pf.const.language.RSC145}</th>
						<th scope="col" title="${pf.const.language.RSC110}">${pf.const.language.RSC110}</th>
					</tr>
				</thead>

				<thead class="filters">
					<tr>
						<td>idmision</td>
						<td>tipomision</td>
						<td>textoinicio</td>
						<td>importe</td>
						<td>encuesta</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr id="${self.data[i].idmision}" class="mission_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].idmision}">${self.data[i].idmision}</td>
					<td class="text-truncate" title="${self.data[i].tipomision}">${self.data[i].tipomision}</td>
					<td class="text-truncate" title="${self.data[i].textoiniciomision}">${self.data[i].textoiniciomision}</td>
					<td class="text-truncate" title="${self.data[i].importe}">${self.data[i].importe}</td>
					<td class="text-center">
						<span class="d-none">${(self.data[i].encuesta == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].encuesta == '1' ? 'checked' : '')}>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC14);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filters td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'activo') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tableMissions = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '75px', targets: 4}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableMissions.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableMissions, 'filters');

		// Detectar click
		$('.mission_selected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	}

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'editCountries':
				PaisesEditController.clickMission(self.data[id]);
				break;
		}
	}
}