class TableTemplates {
	constructor(actions) {
		this.actionsTable = actions;
		this.data = null;
	}

	setEvents() {
		let self = this;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllTemplates', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC167}">${pf.const.language.RSC167}</th>
					</tr>
				</thead>

				<thead class="filtersTemplate">
					<tr>
						<td>nombre</td>
						<td>descripcion</td>
						<td>pais</td>
						<td>archivo</td>
					</tr>
				</thead>

				<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr class="template_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td class="text-truncate" title="${self.data[i].name}">${self.data[i].name}</td>
					<td class="text-truncate" title="${self.data[i].description}">${self.data[i].description}</td>
					<td class="text-truncate" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate" title="${self.data[i].template.replace((self.data[i].idTemplate + '_'), '')}">${self.data[i].template.replace((self.data[i].idTemplate + '_'), '')}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC2049);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersTemplate td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableTemplate = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '50px', targets: 2}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableTemplate.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableTemplate, 'filtersTemplate');

		// Detectar click
		$('.template_selected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	}

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'productsNew':
				ProductosNewController.clickEvents(self.data[id]);
				break;
			case 'productsEdit':
				ProductosEditController.clickEvents(self.data[id]);
				break;
		}
	}
}