let SegmentacionesAutomatizadasController = {
	language: '',
	data: '',
	arrayDelMult: [],
	dateFormat: '',

	reset() {
		let self = this;

		self.language = pf.const.language_table;
		self.data = '';
		self.arrayDelMult = [];
		self.dateFormat = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Información de administrador
		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let userA = JSON.parse(JSONuser);
		self.dateFormat = userA.formatoFecha;

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1973);

		// Opciones de header
		let jsonsubopt = {
			new: 'new',
			export: 'export'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		ajaxComunCallWithCallback('getScheduledSegmentation', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!segmentaciones_automatizadas_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC1349}">${pf.const.language.RSC1349}</th>
					<th scope="col" title="${pf.const.language.RSC342}">${pf.const.language.RSC342}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC368}">${pf.const.language.RSC368}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>pais</td>
					<td>Intervalo</td>
					<td>UnidadDeTiempo</td>
					<td>enabled</td>
					<td>ultimaEjecucion</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			// Para ordenación en columna
			let ultimaEjecucionOrder = self.data[i].UltimaEjecucion.replace(' ', '');

			// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
			let dateTime = '';
			let dateTimeArray = self.data[i].UltimaEjecucion.split(' ');
			let date = dateTimeArray[0].replace(/-/g, '/');
			if(self.dateFormat === 'DDMMAAAA') {
				dateTime = modifyDateFormat(date) + ' ' + dateTimeArray[1];
			} else {
				dateTime = date + ' ' + dateTimeArray[1];
			}

			table += `
				<tr data-id="${self.data[i].id}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].id}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-center c-pointer editRow" title="${self.data[i].TiempoEntreEjecuciones}">${self.data[i].TiempoEntreEjecuciones}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].UnidadDeTiempo}">${self.data[i].UnidadDeTiempo}</td>
					<td class="text-center c-pointer editRow">
						<span class="d-none">${(self.data[i].Activa == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].Activa == '1' ? 'checked' : '')}>
					</td>
					<td class="text-truncate c-pointer editRow" title="${dateTime.trim() == 'undefined' ? '-' : dateTime}">
						<span class="d-none">${ultimaEjecucionOrder}</span>
						${dateTime.trim() == 'undefined' ? '-' : dateTime}
					</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].id}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'enabled') {
				value = optionsSelectAllYesNo();
			} else if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 6}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1330,
				className: 'd-none',
				title: pf.const.language.RSC1330,
				exportOptions: {
					columns: [1, 2, 3, 4, 5],
					format: {
						body(data, row, column, node) {
							let dev = '';
							// Cuenta desde 0 las columnas que se van a exportar
							if(column === 4) {
								dev = data.replace(/<span class="d-none">[A-Za-z0-9-.:]*<\/span>/g, '');
							} else {
								dev = data.replace(/<\/?[^>]+(>|$)/g, '');
							}
							return dev;
						}
					}
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents();

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents();
		});
	},

	tableEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar segmentación programada
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idSegPro', btoa(id));
			window.location.href = '#!segmentaciones_automatizadas_edit';
		});

		// Borrar segmentación programada
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1973;
			let alertText = pf.const.language.RSC1975;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteScheduledSegmentation(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1973;
			let alertText = pf.const.language.RSC1974;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteScheduledSegmentation();
			}, function() {});
		});
	},

	deleteScheduledSegmentation(id = false) {
		let self = this;

		let scheduledSegmentation = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			scheduledSegmentation.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				scheduledSegmentation.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			scheduledSegmentation: JSON.stringify(scheduledSegmentation)
		};
		ajaxComunCallWithCallback('deleteScheduledSegmentation', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1973;
				let successContent = pf.const.language.RSC1976;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/usuarios/segmentaciones_automatizadas.html', 'wrapper', SegmentacionesAutomatizadasController);
			}
		});
	}
};