let SegmentacionesAutomatizadasEditController = {
	language: '',
	id: '',
	data: '',

	resetData() {
		let self = this;

		self.language = pf.const.language_table;
		self.id = atob(sessionStorage.getItem('idSegPro'));
		self.data = '';
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1973 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'btn-save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLanguage();
		self.applyEvents();

		self.getScheduledSegmentation();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.segmentacionesAutomatizadas.sharedEvents(self, 'segmentacionesAutomatizadasEditCountry');

		// Guardar segmentación programada
		$('#btn-save').on('click', function() {
			self.getValues();
		});
	},

	getScheduledSegmentation() {
		let self = this;

		ajaxComunCallWithCallback('getScheduledSegmentation', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let size = ajaxReturn.result.length;
				for(let i = 0; i < size; i++) {
					if(ajaxReturn.result[i].id == self.id) {
						self.data = ajaxReturn.result[i];
						break;
					}
				}

				self.renderValues();
			}
		});
	},

	renderValues() {
		let self = this;

		$('#tiempoEntreEjecuciones').val(self.data.TiempoEntreEjecuciones);
		$('#unidadDeTiempo').val(self.data.UnidadDeTiempo);
		$('#pais').val(self.data.country);
		$('#ultimaEjecucion').val(self.data.UltimaEjecucion);
		$('#ultimaEjecucion').attr('title', self.data.UltimaEjecucion);
		if(self.data.Activa == '1') {
			$('#activa').prop('checked', true);
		}
	},

	getValues() {
		let self = this;

		let comp = true;

		let activa = ($('#activa').prop('checked') == true ? '1' : '0');
		let contry = $('#pais').val();
		if(contry == '') {
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
			comp = false;
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}
		let tiempoEntreEjecuciones = $('#tiempoEntreEjecuciones').val();
		let unidadDeTiempo = $('#unidadDeTiempo').val();

		if(!comp) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let values = {
			id: self.id,
			activa: activa,
			country: contry,
			TiempoEntreEjecuciones: tiempoEntreEjecuciones,
			UnidadDeTiempo: unidadDeTiempo
		};

		self.updateScheduledSegmentation(values);
	},

	updateScheduledSegmentation(values) {
		let parameters = {
			id: values.id,
			Activa: values.activa,
			country: values.country,
			TiempoEntreEjecuciones: values.TiempoEntreEjecuciones,
			UnidadDeTiempo: values.UnidadDeTiempo
		};
		ajaxComunCallWithCallback('updateScheduledSegmentation', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let alertTitle = pf.const.language.RSC1973;
				let alertText = pf.const.language.RSC106;
				let alertBtn = pf.const.language.RSC132;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
					window.location.href = '#!segmentaciones_automatizadas';
				});
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};