stcmbackend.usuarios = {
	sharedEvents(self, modal) {
		$('#backLists').on('click', function() {
			window.location.href = '#!usuarios';
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});

		// Restricciones de carácteres por tecla para nombre de usuario
		$('#nameUser').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC2641, /[.a-z0-9_-]/i);

			return result;
		});

		// Restricciones de carácteres por pegado para nombre de usuario
		$('#nameUser').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC2641, /[^.a-z0-9_-]/gi);
		});

		// Collapse
		addEventArrowTableHeader();

		// Perfilación estado
		$('#searchEstadoPerf').off().on('click', function() {
			stcmbackend.usuarios.getPerfPosibleAnswers(1);
		});

		// Perfilación Género
		$('#searchGeneroPerf').off().on('click', function() {
			stcmbackend.usuarios.getPerfPosibleAnswers(2);
		});
	},

	getPerfPosibleAnswers(option, self) {
		let country = $('#pais').val();
		let email = $('#email').val().trim();

		if(country == '' || email == '') {
			setTimeout(function() {
				$('#closeModalPerf').trigger('click');
			}, 500);

			let warningTitle = pf.const.language.RSC2;
			let warningContent = pf.const.language.RSC1679;
			pf.utils.showInfoDialog(warningTitle, warningContent);

			return;
		}

		let parameters = {
			country: country,
			email: email,
			type: option
		};
		ajaxComunCallWithCallbackOne('getPerfPosibleAnswers', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);

				// Tabla de modal
				stcmbackend.usuarios.renderPerfTable(option, resp);
			}
		});
	},

	renderPerfTable(option, resp, self) {
		let columnName = '';

		if(option == 1) {
			columnName = pf.const.language.RSC564;
		} else if(option == 2) {
			columnName = pf.const.language.RSC151;
		}

		let table = `
			<table id="tableModalPerf" class="table table-hover tr-pointer tRegs">
				<thead>
					<tr>
						<th scope="col" title="${columnName}">${columnName}</th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = resp.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr class="perf_selected c-pointer" data-val="${resp[i].answer}" data-dismiss="modal">
					<td class="text-truncate" title="${resp[i].answer}">${resp[i].answer}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#divModalPerf').html(table);

		let tableModalPerf = $('#tableModalPerf').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableModalPerf.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModalPerf');

		// Detectar click
		$('.perf_selected').click(function() {
			let value = $(this).data('val');
			if(option == 1) {
				$('#estadoPerf').val(value);
			} else if(option == 2) {
				$('#generoPerf').val(value);
			}
		});
	}
};