let UsuariosNuevoController = {
	user: null,
	botConfig: null,
	voiceAssistant: {},
	rols: null,
	extendedInfo: null,
	groups: null,
	groupsOld: null,
	idCPG: '',
	userAdmin: '',
	typeOfRegister: 'email',
	xmpp_domain: '',

	resetData() {
		let self = this;

		self.user = null;
		self.botConfig = {
			idUserOrGroup: null,
			directLineSecret: null,
			botId: null,
			isGroup: null,
			enabled: null,
			botUser: null,
			numVecesNoMatch: null,
			textoNoMatch: null,
			userNotificarNoMatch: null,
			textoNotificarNoMatch: null,
			saludoInicial: null
		};
		self.voiceAssistant = {
			dictionary: '',
		};
		self.rols = null;
		self.extendedInfo = null;
		self.groups = [];
		self.groupsOld = [];
		self.idCPG = getidCPG();
		self.userAdmin = '';
		self.typeOfRegister = 'email';
		self.xmpp_domain = '';
	},

	setEvents() {
		let self = this;
		self.resetData();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		self.userAdmin= user.email;

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.xmpp_domain = config.xmpp_domain;

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'backLists',
			save: 'btn-send'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-send').addClass('main-button');

		// Botones secundarios
		$('#backLists').addClass('secondary-button');

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		if(countries.length === 1) {
			$('#pais').val(countries[0]);
		}

		// Control de CPG
		if(self.idCPG != 0 && self.idCPG != undefined) {
			$('#enabledUser').prop('checked', true);
			$('#enabledUser').prop('disabled', true);
		}

		// Obtener roles
		self.getAllRoles();

		stcmbackend.usuarios.sharedEvents(self);

		// Texto de saludo de asistente de voz oculto en inicio
		$('#textGreetingContainer').hide();

		// Marcadores de obligatoriedad de inputs de asistente de voz ocultos en inicio
		$('.voiceAssisSpan').hide();

		// Idiomas
		ajaxComunCallWithCallback('getIdiomas', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let idiomas = ajaxReturn.result;

				// Búsqueda de idiomas activos y creación de select
				let options = '';
				let sizeA = idiomas.length;
				for(let i = 0; i < sizeA; i++) {
					if(idiomas[i].enabled == 1) {
						options += `<option value="${idiomas[i].isocode}">${idiomas[i].descripcion}</option>`;
					}
				}

				$('#idioma').html(options);
			}
		});

		self.loadLanguage();
		self.applyEvents();

		// Pintar texto de label
		changeLabelsColor();

		// Pestañas de inicio ocultas
		$('.additionalInfoTab').hide();
		$('.botVoiceAssistantTab').hide();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
		pf.rsc.translateByTag('placeholder');

		let arrObj = ['RSC300'];
		pf.rsc.translateByTagHTMLFormat('simple', arrObj);

		// TITLES
		$('#infoTab').attr('title', pf.const.language.RSC1314);
		$('#additionalInfoTab').attr('title', pf.const.language.RSC2524);
		$('#botVoiceAssistantTab').attr('title', pf.const.language.RSC2525);
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// Cambio de pestañas
		$('.tab-button').on('click', function() {
			$('.tab-button').removeClass('activeTB');
			$(this).addClass('activeTB');

			// Ocultar todas las secciones
			$('.infoTab').hide();
			$('.additionalInfoTab').hide();
			$('.botVoiceAssistantTab').hide();

			// Mostrar la sección activa
			let id = $(this).data('id');
			$('.' + id).show();
		});

		// Selector entre E-mail y Nombre
		$('#typeOfRegister1').on('change', function() {
			$('#email').val('');
			$('#nameUser').val('');

			if($('#typeOfRegister1').prop('checked')) {
				$('#emailContainer').removeClass('d-none');
				$('#nameUserContainer').addClass('d-none');
				self.typeOfRegister = 'email';

				$('.option-box-check-3').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});
		$('#typeOfRegister2').on('change', function() {
			$('#email').val('');
			$('#nameUser').val('');

			if($('#typeOfRegister2').prop('checked')) {
				$('#nameUserContainer').removeClass('d-none');
				$('#emailContainer').addClass('d-none');
				self.typeOfRegister = 'nameUser';

				$('.option-box-check-3').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});

		/* TTT 04/10/23 */
		/* // Tipo E-mail
		$('#email').on('blur', function() {
			if(self.typeOfRegister == 'email') {
				let value = $('#email').val().trim();
				$('#nameUser').val(value);
			}
		});

		// Tipo Nombre
		$('#nameUser').on('blur', function() {
			if(self.typeOfRegister == 'nameUser') {
				let value = $('#nameUser').val().trim();
				// Reemplaza espacios y guines bajos
				value = value.replace(/[\s+_]/g, '');
				// Remplaza puntos pares
				value = value.replace(/\.{2}/g, '');
				// Añade @[dominio]
				value = value + '@' + self.xmpp_domain;

				$('#email').val(value);
			}
		}); */
		/* TTT 04/10/23 */

		// Contraseña
		$('#passwordAPI').focus(function() {
			$('#passwordAPI').attr('type', 'password');
		})

		// Mostrar contraseña
		$('#btn-password').mouseup(function() {
			$('#passwordAPI').attr('type', 'password');
		});
		$('#btn-password').mousedown(function() {
			$('#passwordAPI').attr('type', 'text');
		});

		// Perfil
		$('#btn_searchPerfil').off().on('click', function() {
			self.userType = 'perfil';
			tablePerfiles.setEvents('usersNew');
		});

		// País
		let countryModal = new TableCountries(0, 'newUserCountry');
		$('#searchCountry').off().on('click', function() {
			self.userType = 'country';
			countryModal.setEvents();
		});

		// Cargar usuarios admin
		let admin = new TableUsers(0, 'newUser');

		// Cargar usuarios bot user
		$('#btn-botUser').click(function() {
			self.userType = 'userBot';
			admin.setEvents();
		});

		// Cargar usuarios para añadir al grupo
		self.crewObject = new TableGroups(1, 'newUser');
		$('#btn-addGroup').click(function() {
			self.userType = 'addGroups';
			self.crewObject.setEvents();
		});

		// Cargar usuarios notificacion
		let userNotif = new TableUsers(0, 'newUser');
		$('#btn-userNotificarNoMatch').click(function() {
			self.userType = 'userNotif';
			userNotif.setEvents();
		});

		$('#btn-role').click(function() {
			self.userType = 'rol';
			tableRol.setEvents('newUser');
		});

		$('#btn-bots').click(function() {
			self.userType = 'bots';
			tableBots.setEvents('newUser');
		});

		// Cambio select rol
		$('#role').change(function() {
			self.roleChange();
		});

		// País de asistente de voz
		let countryModalVoiceAssis = new TableCountries(0, 'newUserCountry');
		$('#searchCountryVoiceAssis').off().on('click', function() {
			self.userType = 'countryVoiceAssis';
			countryModalVoiceAssis.setEvents();
		});

		// Asistente de voz
		// Si se selecciona 'bot' se deselecciona el asistente de voz y viceversa
		$('#enabled').off().on('change', function() {
			if($('#enabled').prop('checked')) {
				// Limpieza de asistente de voz
				$('#voiceAssisEnabled').prop('checked', false);
				$('#dictionary').val('');
				self.voiceAssistant.dictionary = '';
				$('#voiceAssistantUser').val('');
				$('#paisVoiceAssis').val('');
				$('#voiceAssistantName').text('');
				$('#voiceAssisSaludoInicial').prop('checked', false);
				$('#textGreeting').val('');
				$('#voiceAssisNumVecesNoMatch').val('');
				$('#voiceAssisTextoNoMatch').val('');
				$('#voiceAssisTextoContactNotice').val('');
				$('#notificationTypeUser').prop('checked', true);
				$('#voiceAssisUserNotificarNoMatch').val('');
				$('#voiceAssisUserNotificarNoMatchName').text('');
				$('#voiceAssisTextoNotificarNoMatch').val('');

				// Se oculta la obligatoriedad de inputs de asistente de voz
				$('.voiceAssisSpan').hide();
			}
		});

		$('#voiceAssisEnabled').off().on('change', function() {
			if($('#voiceAssisEnabled').prop('checked')) {
				// Limpieza de bot
				$('#enabled').prop('checked', false);
				$('#directLineSecret').val('');
				$('#botId').val('');
				$('#botUser').val('');
				$('#botUserName').text('');
				$('#saludoInicial').prop('checked', false);
				$('#numVecesNoMatch').val('');
				$('#textoNoMatch').val('');
				$('#userNotificarNoMatch').val('');
				$('#userNotificarNoMatchName').text('');
				$('#textoNotificarNoMatch').val('');

				// Se hace visible la obligatoriedad de inputs del asistente de voz
				$('.voiceAssisSpan').show();
			} else {
				// Se oculta la obligatoriedad de inputs de asistente de voz
				$('.voiceAssisSpan').hide();
			}
		});

		// Control de saludo de asistente de voz
		$('#voiceAssisSaludoInicial').off().on('change', function() {
			if($('#voiceAssisSaludoInicial').prop('checked')) {
				// Mostrar texto de saludo
				$('#textGreetingContainer').show();
			} else {
				// Ocultar texto de saludo
				$('#textGreeting').val('');
				$('#textGreetingContainer').hide();
			}
		});

		// Cargar diccionarios
		let dictionaries = new TableDictionary('UsuariosNuevoController');
		$('#btn-dictionary').click(function() {
			self.userType = 'dictionaries';
			dictionaries.setEvents();
		});

		// Cargar usuarios asistente de voz
		let voiceAssistantUser = new TableUsers(0, 'newUser');
		$('#btn-voiceAssistantUser').click(function() {
			self.userType = 'userVoiceAssistant';
			voiceAssistantUser.setEvents();
		});

		// Tipo de usuario
		$('#staff').on('change', function() {
			if($('#staff').prop('checked')) {
				$('.option-box-check').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});
		$('#consejero').on('change', function() {
			if($('#consejero').prop('checked')) {
				$('.option-box-check').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});

		// Tipo de notificación
		$('#notificationTypeUser').on('change', function() {
			if($('#notificationTypeUser').prop('checked')) {
				$('#voiceAssisTextoNotificarNoMatchContainer').show();

				$('.option-box-check-2').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});
		$('#notificationTypeMail').on('change', function() {
			if($('#notificationTypeMail').prop('checked')) {
				$('#voiceAssisTextoNotificarNoMatchContainer').show();

				$('.option-box-check-2').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});
		$('#notificationTypeVideo').on('change', function() {
			if($('#notificationTypeVideo').prop('checked')) {
				$('#voiceAssisTextoNotificarNoMatchContainer').hide();
				$('#voiceAssisTextoNotificarNoMatch').val('');

				$('.option-box-check-2').removeClass('option-box-check-selected');
				$(this).parent().addClass('option-box-check-selected');
			}
		});

		// Cargar usuarios notificacion asistente de voz
		$('#btn-voiceAssisUserNotificarNoMatch').click(function() {
			self.userType = 'userNotifVoiceAssistant';
			voiceAssistantUser.setEvents();
		});

		// Comprobación para guardar usuario
		$('#btn-send').click(function() {
			// Comprobar que los campos esta rellenos
			let clabeOK = {ok: false};
			if($('#pais').val() == 'mex') {
				clabeOK = clabe.validate($('#userAccount').val());
			} else {
				clabeOK.ok = true;
			}

			if(($('#nameUser').val().length == 0 && self.typeOfRegister == 'nameUser') || (!clabeOK.ok && $('#userAccount').val().length > 0) || $('#passwordAPI').val().trim() === '') {
				let alertText = pf.const.language.RSC101;
				if($('#nameUser').val().length == 0) {
					$('#nameUser').addClass('is-invalid');
					$('[for="nameUser"]').addClass('is-invalid');
				} else {
					$('#nameUser').removeClass('is-invalid');
					$('[for="nameUser"]').removeClass('is-invalid');
				}

				if(!clabeOK.ok && $('#userAccount').val().length > 0) {
					$('#userAccount').addClass('is-invalid');
					$('[for="userAccount"]').addClass('is-invalid');
					alertText = pf.const.language.RSC315;
				} else {
					$('#userAccount').removeClass('is-invalid');
					$('[for="userAccount"]').removeClass('is-invalid');
				}

				if($('#passwordAPI').val().trim() == '') {
					$('#passwordAPI').val('');
					$('#passwordAPI').addClass('is-invalid');
					$('#pass-group').addClass('group-invalid');
					$('[for="passwordAPI"]').addClass('is-invalid');
				} else {
					$('#passwordAPI').removeClass('is-invalid');
					$('#pass-group').removeClass('group-invalid');
					$('[for="passwordAPI"]').removeClass('is-invalid');
				}

				let alertTitle = pf.const.language.RSC78;
				pf.utils.showInfoDialog(alertTitle, alertText);
			} else {
				$('#nameUser').removeClass('is-invalid');
				$('[for="nameUser"]').removeClass('is-invalid');
				$('#userAccount').removeClass('is-invalid');
				$('[for="userAccount"]').removeClass('is-invalid');

				let objInfo = {
					accept: {
						text: pf.const.language.RSC78
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC78;
				let alertText = pf.const.language.RSC105;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.sendData();
				}, function() {});
			}
		});
	},

	getAllRoles() {
		let self = this;

		ajaxComunCallWithCallback('getAllRoles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				// Comprobación de array
				if(!Array.isArray(ajaxReturn.result)) {
					self.rols = [];
				} else {
					self.rols = ajaxReturn.result;
				}

				// Cargar roles select
				let rolePerm = {};
				for(let i = 0; i < self.rols.length; i++) {
					rolePerm[self.rols[i].role] = self.rols[i];
				};
				self.rols = rolePerm;
			}
		});
	},

	roleChange() {
		let self = this;

		let role = $('#role').val();
		if(role.length > 0) {
			let user = false;
			if($('#nameUser').val().length == 0) {
				user = true;
				$('#nameUser').val('nameUser');
			}

			TableRoles.setEvents(self.rols[role], 'permission', 'editUser');
			setTimeout(function() {
				if(user) {
					$('#nameUser').val('');
				}
			}, 1000);
		} else {
			$('#permission').html('');
		}
	},

	sendData() {
		let self = this;

		let groups = [];
		for(let i = 0; i < self.groups.length; i++) {
			groups.push(self.groups[i].id);
		}

		let email = $('#email').val().trim();
		let userName = $('#nameUser').val().trim();

		let valiEmail = false;
		if(self.typeOfRegister == 'email') {
			// Verificación de e-mail
			if(email != '' && pf.utils.validateEmail(email)) {
				$('#email').removeClass('is-invalid');
				$('[for="email"]').removeClass('is-invalid');
				valiEmail = true;
			} else {
				$('#email').addClass('is-invalid');
				$('[for="email"]').addClass('is-invalid');
				valiEmail = false;
			}
		} else {
			email = userName;
			valiEmail = true;
		}

		let mailToNotify = $('#communicationEmail').val().trim();
		let phoneToNotify = $('#communicationTelf').val().trim();

		// Verificación de e-mail de notificación
		let valiEmailNoti = false;
		if((mailToNotify != '' && pf.utils.validateEmail(mailToNotify)) || mailToNotify == '') {
			$('#communicationEmail').removeClass('is-invalid');
			$('[for="communicationEmail"]').removeClass('is-invalid');
			valiEmailNoti = true;
		} else {
			$('#communicationEmail').addClass('is-invalid');
			$('[for="communicationEmail"]').addClass('is-invalid');
			valiEmailNoti = false;
		}

		// Verificación de país
		let valiCountry = false;
		if($('#pais').val() != '') {
			$('#pais').removeClass('is-invalid');
			$('#pais-group').removeClass('group-invalid');
			$('[for="pais"]').removeClass('is-invalid');
			valiCountry = true;
		} else {
			$('#pais').addClass('is-invalid');
			$('#pais-group').addClass('group-invalid');
			$('[for="pais"]').addClass('is-invalid');
			valiCountry = false;
		}

		if(!valiEmail || !valiEmailNoti || !valiCountry) {
			pf.utils.alerts.showCompleteAllFields();

			return false;
		}

		// Comprobar checkboxs
		if($('#saludoInicial').prop('checked')) {
			$('#saludoInicial').val(1);
		} else {
			$('#saludoInicial').val(0);
		}

		if($('#enabledUser').prop('checked')) {
			$('#enabledUser').val(1);
		} else {
			$('#enabledUser').val(0);
		}

		if($('#enabled').prop('checked')) {
			$('#enabled').val(1);
		} else {
			$('#enabled').val(0);
		}

		if($('#staff').prop('checked')) {
			$('#staff').val(1);
		} else {
			$('#staff').val(0);
		}

		if($('#consejero').prop('checked')) {
			$('#consejero').val(1);
		} else {
			$('#consejero').val(0);
		}

		let user = {
			email: email,
			password: $('#passwordAPI').val(),
			nameUser: $('#userNombre').val(),
			role: $('#role').val(),
			enabled: $('#enabledUser').val(),
			participants: groups,
			idCPG: self.idCPG
		};

		let extendedInfo = {
			consejero: $('#consejero').val(),
			expirationDate: null,
			name: null,
			numMisionesIncumplidas: $('#numMisionesIncumplidas').val(),
			registered: null,
			staff: $('#staff').val(),
			stamp: null,
			token: null,
			userAccount: $('#userAccount').val(),
			userApellidos: $('#userApellidos').val(),
			userApellidos2: $('#userApellidos2').val(),
			userEmail: null,
			userIdentificador: $('#useridentificador').val(),
			userNombre: $('#userNombre').val(),
			userPass: null,
			welcome: null,
			country: $('#pais').val(),
			language: $('#idioma').val(),
			mailToNotify: mailToNotify,
			phoneToNotify: phoneToNotify,
			profile: $('#perfil').val(),
			questionEstado: $('#estadoPerf').val(),
			questionEdadFecha: $('#edadPerf').val(),
			questionGenero: $('#generoPerf').val(),
			questionABI: $('#nsePerf').val()
		};

		let botConfig = {
			idUserOrGroup: '',
			directLineSecret: ($('#directLineSecret').val().trim() === '' ? null : $('#directLineSecret').val().trim()),
			botId: $('#botId').val(),
			isGroup: 0,
			enabled: $('#enabled').val(),
			botUser: $('#botUser').val(),
			numVecesNoMatch: $('#numVecesNoMatch').val(),
			textoNoMatch: $('#textoNoMatch').val(),
			userNotificarNoMatch: $('#userNotificarNoMatch').val(),
			messageNotifNoMatch: $('#textoNotificarNoMatch').val(),
			SaludoInicial: $('#saludoInicial').val()
		};

		let notificationType = 'user';
		if($('#notificationTypeMail').prop('checked')) {
			notificationType = 'mail';
		} else if($('#notificationTypeVideo').prop('checked')) {
			notificationType = 'videocall';
		}

		// Configuración de asistente de voz
		let voiceAssistant = {
			enabled: ($('#voiceAssisEnabled').prop('checked') ? '1' : '0'),
			dictionary: self.voiceAssistant.dictionary,
			voiceAssisUser: $('#voiceAssistantUser').val(),
			country: $('#paisVoiceAssis').val(),
			gender: $('#genderVoiceAssis').val(),
			applyGreeting: ($('#voiceAssisSaludoInicial').prop('checked') ? '1' : '0'),
			textGreeting: $('#textGreeting').val().trim(),
			numVecesNoMatch: $('#voiceAssisNumVecesNoMatch').val(),
			textoNoMatch: $('#voiceAssisTextoNoMatch').val().trim(),
			texttouser: $('#voiceAssisTextoContactNotice').val().trim(),
			notificationType: notificationType,
			userNotificarNoMatch: $('#voiceAssisUserNotificarNoMatch').val(),
			textoNotificarNoMatch: $('#voiceAssisTextoNotificarNoMatch').val().trim()
		};

		// Control de inputs obligatorios del asistente de voz
		let voiceAssistantEmpty = false;

		// Saludo si es aplicable
		if(voiceAssistant.enabled == '1' && voiceAssistant.applyGreeting == '1' && voiceAssistant.textGreeting == '') {
			$('#textGreeting').addClass('is-invalid');
			$('[for="textGreeting"]').addClass('is-invalid');
			voiceAssistantEmpty = true;
		} else {
			$('#textGreeting').removeClass('is-invalid');
			$('[for="textGreeting"]').removeClass('is-invalid');
		}

		// Número de veces no match
		if(voiceAssistant.enabled == '1' && voiceAssistant.numVecesNoMatch == '') {
			$('#voiceAssisNumVecesNoMatch').addClass('is-invalid');
			$('[for="voiceAssisNumVecesNoMatch"]').addClass('is-invalid');
			voiceAssistantEmpty = true;
		} else {
			$('#voiceAssisNumVecesNoMatch').removeClass('is-invalid');
			$('[for="voiceAssisNumVecesNoMatch"]').removeClass('is-invalid');
		}

		// Texto "no match" para el usuario
		if(voiceAssistant.enabled == '1' && voiceAssistant.textoNoMatch == '') {
			$('#voiceAssisTextoNoMatch').addClass('is-invalid');
			$('[for="voiceAssisTextoNoMatch"]').addClass('is-invalid');
			voiceAssistantEmpty = true;
		} else {
			$('#voiceAssisTextoNoMatch').removeClass('is-invalid');
			$('[for="voiceAssisTextoNoMatch"]').removeClass('is-invalid');
		}

		// Texto aviso de contacto
		if(voiceAssistant.enabled == '1' && voiceAssistant.texttouser == '') {
			$('#voiceAssisTextoContactNotice').addClass('is-invalid');
			$('[for="voiceAssisTextoContactNotice"]').addClass('is-invalid');
			voiceAssistantEmpty = true;
		} else {
			$('#voiceAssisTextoContactNotice').removeClass('is-invalid');
			$('[for="voiceAssisTextoContactNotice"]').removeClass('is-invalid');
		}

		if(voiceAssistantEmpty) {
			pf.utils.alerts.showCompleteAllFields();
			return false;
		}

		let parameters = {
			user: JSON.stringify(user),
			extendedInfo: JSON.stringify(extendedInfo),
			botConfig: JSON.stringify(botConfig),
			voiceAssistant: JSON.stringify(voiceAssistant),
			userAdmin: self.userAdmin,
			wellcomeChat: $('#wellcomeChat').prop('checked') ? '1' : '0'
		};
		ajaxComunCallWithCallbackOne('newUser', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);
				if(resp.result == 'User exists') {
					let alertTitle = pf.const.language.RSC78;
					let alertText = pf.const.language.RSC314;
					pf.utils.showInfoDialog(alertTitle, alertText);
				} else if(resp.status == 'OK') {
					let alertTitle = pf.const.language.RSC78;
					let alertText = pf.const.language.RSC106;
					let alertBtn = pf.const.language.RSC132;
					pf.utils.showInfoDialog(alertTitle, alertText, alertBtn, function() {
						window.location.href = '#!usuarios';
					});
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = resp.result;
					pf.utils.showInfoDialog(errorTitle, errorContent);
					if(resp.result == 'Not authorized') {
						pf.ajax.setWindowLocationIndex();
					}
				}
			}
		});
	},

	clickEvents(data, type = null) {
		let self = this;

		if(type) {
			self.userType = type;
		}

		self.userClick = data;
		switch(self.userType) {
			case 'userBot':
				$('#botUser').val(self.userClick.id);
				$('#botUserName').text(self.userClick.nameUser);
				break;

			case 'userNotif':
				$('#userNotificarNoMatch').val(self.userClick.id);
				$('#userNotificarNoMatchName').text(self.userClick.nameUser);
				break;

			case 'bots':
				$('#directLineSecret').val(self.userClick.directLine);
				$('#botId').val(self.userClick.botName);
				break;

			case 'rol':
				$('#role').val(self.userClick.role);
				self.roleChange();
				break;

			case 'addGroups':
				let newGroups = [];

				for(let i = 0; i < data.length; i++) {
					// buscar rol en el grupo
					let role = 'participante';
					for(let j = 0; j < self.groups.length; j++) {
						if(self.groups[j].id == data[i].idGroup) {
							role = 'Admin';
						}
					}

					newGroups.push({
						id: data[i].idGroup,
						jid: data[i].jidUser,
						name: data[i].groupName,
						nameVisual: data[i].name,
						role: role
					});
				}

				self.groups = newGroups;
				self.crewObject.groups = self.groups;
				TableGroupsUser.setEvents(self.groups, 'divGroupsTable', 'newUser');
				break;

			// Eliminar usuario de grupo
			case 'removeGroup':
				self.groups.splice(data, 1);
				self.crewObject.groups = self.groups;
				TableGroupsUser.setEvents(self.groups, 'divGroupsTable', 'newUser');
				break;

			// Seleccionar país
			case 'country':
				$('#pais').val(data.isocode);
				break;

			// Seleccionar perfil
			case 'perfil':
				$('#perfil').val(data.id);
				$('#perfil').attr('title', data.id);
				break;

			// Diccionario
			case 'dictionaries':
				$('#dictionary').val(data.description);
				self.voiceAssistant.dictionary = data.idDictionary;
				break;

			// Usuario de asistente de voz
			case 'userVoiceAssistant':
				$('#voiceAssistantUser').val(data.id);
				$('#voiceAssistantName').text(data.nameUser);
				break;

			// Seleccionar país para asistente de voz
			case 'countryVoiceAssis':
				$('#paisVoiceAssis').val(data.isocode);
				break;

			// Usuario a notificar de asistente de voz
			case 'userNotifVoiceAssistant':
				$('#voiceAssisUserNotificarNoMatch').val(data.id);
				$('#voiceAssisUserNotificarNoMatchName').text(data.nameUser);
				break;
		}
	}
};