class Config {
	constructor() {
		this.data = null;
		this.controller = null;
	}

	setEvents() {
		let self = this;
		if(!self.data) {
			self.requestData();
		}
	}

	getData() {
		return new Promise((resolve, reject) => {
			let self = this;

			ajaxComunCallWithCallback('getCMBPConfig', {}, function(ajaxReturn) {
				if(ajaxReturn) {
					self.data = ajaxReturn.result[0];
					resolve(self.data);
				}
			});
		});
	}

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getCMBPConfig', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result[0];
				self.sendConfig();
			}
		});
	}

	sendConfig() {
		let self = this;
		switch (this.controller) {
			case 'newNotification':
				NotificacionesNuevaController.reciveConfig(self.data);
				break;
			case 'editNotification':
				NotificacionesEditarController.reciveConfig(self.data);
				break;
			case 'newMission':
				MisionesNewController.reciveConfig(self.data);
				break;
			case 'editMission':
				MisionesEditController.reciveConfig(self.data);
				break;
			case 'editCountries':
				PaisesEditController.reciveConfig(self.data);
				break;
			case 'missions':
				MisionesController.reciveConfig(self.data);
				break;
			case 'projects':
				ProyectosController.reciveConfig(self.data);
				break;
			case 'newTenant':
				TenantNewController.reciveConfig(self.data);
				break;
			case 'editTenant':
				TenantEditController.reciveConfig(self.data);
				break;
			case 'newCPG':
				CPGNewController.reciveConfig(self.data);
				break;
			case 'editCPG':
				CPGEditController.reciveConfig(self.data);
				break;
			default:
				break;
		}
	}
}