class SendCDPData {
	constructor(values) {
		this.action = values.action;
		this.token = values.token;
		this.dataSurvey = values.dataSurvey;
		this.dataSurveyLength = values.dataSurvey.length;
		this.dataUsers = values.dataUsers;
		this.cdp_endpoint_KEY = values.cdp_endpoint_KEY;
		this.abi_country_endpoint = values.abi_country_endpoint;
		this.abi_survey_id = values.abi_survey_id;
		this.abi_survey_title = values.abi_survey_title;
		this.abi_earned_points = values.abi_earned_points;
		this.abi_program_name = values.abi_program_name;
	}

	start() {
		let self = this;

		// Control envío Encuestas o usuarios
		if(self.dataSurvey == null) {
			self.sendCDPDataUsers();
		} else {
			self.sendCDPData();
		}
	}

	sendCDPData() {
		let self = this;

		// Mostrar alarma de notificación
		$('#senCDPDataAlert').show();
		$('#senCDPDataAlert .progress-line-wrapper').show();

		// Mensaje de notificación
		let notificationTitle = '';
		let notificationContent = '';

		let parameters = {
			dataSurvey: self.dataSurvey,
			cdp_endpoint_KEY: self.cdp_endpoint_KEY,
			abi_country_endpoint: self.abi_country_endpoint,
			abi_survey_id: self.abi_survey_id,
			abi_survey_title: self.abi_survey_title,
			abi_earned_points: self.abi_earned_points,
			abi_program_name: self.abi_program_name
		};
		ajaxComunCallWithCallbackOne(self.action, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);

				if(resp.status === 'OK') {
					notificationTitle = pf.const.language.RSC612;
					if(self.dataSurveyLength > 10000) {
						// Faltan registros por enviar
						notificationContent = pf.const.language.RSC2101;
					} else {
						notificationContent = 'sendCDPData SUCCESS';
					}
				} else {
					notificationTitle = pf.const.language.RSC61;
					notificationContent = resp.result;
				}
			}

			// Mostrar fin de alarma de notificación
			$('#senCDPDataAlert .bi-bell').css('cursor', 'pointer');
			$('#senCDPDataAlert .progress-line-wrapper').hide();
			$('#senCDPDataAlert .report-badge').text('1');
			$('#senCDPDataAlert .report-badge').show();
			$('#senCDPDataAlert .report-badge').addClass('background-color-main');
			$('#senCDPDataAlert .bi-bell').off().on('click', function() {
				$('#senCDPDataAlert').hide();
				$('#senCDPDataAlert .progress-line-wrapper').hide();
				$('#senCDPDataAlert .bi-bell').css('cursor', 'default');
				$('#senCDPDataAlert .report-badge').text('');
				$('#senCDPDataAlert .report-badge').hide();
				$('#senCDPDataAlert .report-badge').removeClass('background-color-main');
				pf.utils.showInfoDialog(notificationTitle, notificationContent);
			});
		});
	}

	sendCDPDataUsers() {
		let self = this;

		// Mostrar alarma de notificación
		$('#senCDPDataAlert').show();
		$('#senCDPDataAlert .progress-line-wrapper').show();

		// Mensaje de notificación
		let notificationTitle = '';
		let notificationContent = '';

		let parameters = {
			dataUsers: self.dataUsers,
			cdp_endpoint_KEY: self.cdp_endpoint_KEY
		};
		ajaxComunCallWithCallbackOne(self.action, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);

				if(resp.status === 'OK') {
					notificationTitle = pf.const.language.RSC612;
					notificationContent = 'sendCDPData SUCCESS';
				} else {
					notificationTitle = pf.const.language.RSC61;
					notificationContent = resp.result;
				}
			}

			// Mostrar fin de alarma de notificación
			$('#senCDPDataAlert .bi-bell').css('cursor', 'pointer');
			$('#senCDPDataAlert .progress-line-wrapper').hide();
			$('#senCDPDataAlert .report-badge').text('1');
			$('#senCDPDataAlert .report-badge').show();
			$('#senCDPDataAlert .report-badge').addClass('background-color-main');
			$('#senCDPDataAlert .bi-bell').off().on('click', function() {
				$('#senCDPDataAlert').hide();
				$('#senCDPDataAlert .progress-line-wrapper').hide();
				$('#senCDPDataAlert .bi-bell').css('cursor', 'default');
				$('#senCDPDataAlert .report-badge').text('');
				$('#senCDPDataAlert .report-badge').hide();
				$('#senCDPDataAlert .report-badge').removeClass('background-color-main');
				pf.utils.showInfoDialog(notificationTitle, notificationContent);
			});
		});
	}
}