function createSubOptionCountry(id, btnDelete, style = '') {
	if(id == undefined) {
		return '';
	}

	let addDelete = '';
	if(btnDelete) {
		addDelete = `
			<span id="countryDelete" class="c-pointer ml-2" title="${pf.const.language.RSC95}">
				${stcmbackend.svg.trash}
			</span>
		`;
	}

	return `
		<div class="ma-le-5" ${style}>
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC550}" aria-label="country" data-iso="" title="${pf.const.language.RSC550}" disabled>
				${addDelete}
				<div class="input-group-append d-block">
					<button id="searchCountry" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#modalContainer">
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionCountrySimple(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="input-group new-input-style new-input-style-action-page ma-le-5">
			<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC2514}" aria-label="country" data-iso="" title="${pf.const.language.RSC2514}" disabled>
			<div class="input-group-append d-block">
				<button id="searchCountry" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#modalContainer">
					${stcmbackend.svg.threeDotsWithoutMargin}
				</button>
			</div>
		</div>
	`;
}

function createSubOptionProject(id, style = '') {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="ma-le-5" ${style}>
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC10}" aria-label="Proyecto" disabled>
				<div class="input-group-append d-block">
					<button id="searchProject" type="button" class="btn btn-outline-secondary f-content" data-toggle="modal" data-target="#projectTable">
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionSurvey(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="ma-le-5">
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC110}" aria-label="Encuesta" disabled>
				<div class="input-group-append d-block">
					<button id="searchPoll" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#pollTable">
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionQuestion(id, suffix = '') {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="ma-le-5">
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC111}" aria-label="Pregunta" disabled>
				<div class="input-group-append d-block">
					<button id="searchQuestion${suffix}" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#questTable${suffix}" disabled>
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionMision(id, style = '', disabled = 'disabled') {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="ma-le-5" ${style}>
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC14}" aria-label="Mision" disabled>
				<div class="input-group-append d-block">
					<button id="searchMission" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#missionTable" ${disabled}>
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionUser(id, style = '', disabled = 'disabled') {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="ma-le-5" ${style}>
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC2}" aria-label="Mision" disabled>
				<div class="input-group-append d-block">
					<button id="searchUser" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#userTable" ${disabled}>
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionRefresh(id, disabled) {
	if(id == undefined) {
		return '';
	}

	let btnDisabled = '';
	if(disabled) {
		btnDisabled = 'disabled';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC46}" ${btnDisabled}>
			${stcmbackend.svg.arrowRepeat}
			<span class="ml-1">${pf.const.language.RSC46}</span>
		</button>
	`;
}

function createSubOptionNew(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 he-36 d-flex align-items-center" title="${pf.const.language.RSC7}">
			${stcmbackend.svg.plus}
			<span class="mr-2">${pf.const.language.RSC7}</span>
		</button>
	`;
}

function createSubOptionExport(id, disabled) {
	if(id == undefined) {
		return '';
	}

	let btnDisabled = '';
	if(disabled) {
		btnDisabled = 'disabled';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn button-excel d-flex align-items-center ma-le-5" title="${pf.const.language.RSC47}" ${btnDisabled}>
			${stcmbackend.svg.download}
			<span class="ml-1">${pf.const.language.RSC47}</span>
		</button>
	`;
}

function createSubOptionSearch(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn d-flex align-items-center ma-le-5" title="${pf.const.language.RSC1787}">
			${stcmbackend.svg.search}
			<span class="ml-1">${pf.const.language.RSC1787}</span>
		</button>
	`;
}

function createSubOptionBack(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center" title="${pf.const.language.RSC271}">
			${stcmbackend.svg.arrowLeft}
			<span class="ml-1">${pf.const.language.RSC271}</span>
		</button>
	`;
}

function createSubOptionSave(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav he-36 ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC78}">
			${stcmbackend.svg.disketteSave}
			<span class="ml-1">${pf.const.language.RSC78}</span>
		</button>
	`;
}

function createSubOptionSaveMassive(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC1303}" disabled>
			${stcmbackend.svg.disketteSave}
			<span class="ml-1">${pf.const.language.RSC1303}</span>
		</button>
	`;
}

function createSubOptionSaveExecute(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC442}">
			${stcmbackend.svg.play}
			<span class="ml-1">${pf.const.language.RSC442}</span>
		</button>
	`;
}

function createSubOptionExecute(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5" title="${pf.const.language.RSC444}">
			${stcmbackend.svg.play}
			<span class="d-none d-xl-inline">${pf.const.language.RSC444}</span>
		</button>
	`;
}

function createSubOptionActiveMassive(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC1308}" disabled>
			${stcmbackend.svg.personCheckWithoutColor}
			<span class="ml-1">${pf.const.language.RSC1308}</span>
		</button>
	`;
}

function createSubOptionDeactiveMassive(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC1309}" disabled>
			${stcmbackend.svg.personXWithoutColor}
			<span class="ml-1">${pf.const.language.RSC1309}</span>
		</button>
	`;
}

function createSubOptionChangePass(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC287}">
			${stcmbackend.svg.lockWithoutColor}
			<span class="ml-1">${pf.const.language.RSC287}</span>
		</button>
	`;
}

function createSubOptionGenerateLayout(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC5}">
			${stcmbackend.svg.download}
			<span class="ml-2">${pf.const.language.RSC5}</span>
		</button>
	`;
}

function createSubOptionImport(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center" title="${pf.const.language.RSC316}">
			${stcmbackend.svg.upload}
			<span class="ml-1">${pf.const.language.RSC316}</span>
		</button>
	`;
}

function createSubOptionImportLayout(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC4}">
			${stcmbackend.svg.upload}
			<span class="ml-2">${pf.const.language.RSC4}</span>
		</button>
	`;
}

function createSubOptionImportTemplate(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC2089}">
			${stcmbackend.svg.upload}
			<span class="ml-2">${pf.const.language.RSC2089}</span>
		</button>
	`;
}

function createSubOptionImportDictionary(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" data-toggle="modal" data-target="#modalContainer" title="${pf.const.language.RSC2434}">
			${stcmbackend.svg.book}
			<span class="ml-1">${pf.const.language.RSC2434}</span>
		</button>
	`;
}

function createSubOptionVisualizacionGraf(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="form-check form-check-inline ma-le-5 mr-0">
			<label for="${id}" class="form-check-label">${pf.const.language.RSC1387}</label>
			<input id="${id}" type="checkbox" class="form-check-input ml-1" checked>
		</div>
	`;
}

function createSubOptionTutorial(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn" title="${pf.const.language.RSC1390}">
			${stcmbackend.svg.book}
			<span class="d-none d-xl-inline">${pf.const.language.RSC1390}</span>
		</button>
	`;
}

function createSubOptionSync(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC1266}">
			${stcmbackend.svg.arrowDownUp}
			<span class="ml-1">${pf.const.language.RSC1266}</span>
		</button>
	`;
}

function createSubOptionDistributionList(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC12}" disabled>
			${stcmbackend.svg.chatDots}
			<span class="ml-1">${pf.const.language.RSC12}</span>
		</button>
	`;
}

function createSubOptionDelete(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn d-flex align-items-center" title="${pf.const.language.RSC226}">
			${stcmbackend.svg.trash}
			<span class="ml-1">${pf.const.language.RSC226}</span>
		</button>
	`;
}

function createSubOptionDistribute(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn d-none ma-le-5" title="${pf.const.language.RSC524}">
			${stcmbackend.svg.cpu}
			<span class="d-none d-xl-inline">${pf.const.language.RSC524}</span>
		</button>
	`;
}

function createSubOptionDisableCPG(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5" title="${pf.const.language.RSC1726}">
			${stcmbackend.svg.personXWithoutColor}
			<span class="d-none d-xl-inline">${pf.const.language.RSC1726}</span>
		</button>
	`;
}

function createSubOptionExecuteSeg(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center" title="${pf.const.language.RSC1767}">
			${stcmbackend.svg.play}
			<span class="ml-1">${pf.const.language.RSC1767}</span>
		</button>
	`;
}

function createSubOptionVideocallManageUsers(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center" data-toggle="modal" data-target="#addParticipants" title="${pf.const.language.RSC1460}">
			${stcmbackend.svg.peopleWithoutColor}
			<span class="ml-1">${pf.const.language.RSC1460}</span>
		</button>
	`;
}

function createSubOptionAdd(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" data-toggle="modal" data-target="#objectivesTable" title="${pf.const.language.RSC93}">
			${stcmbackend.svg.plusSquare}
			<span class="ml-1">${pf.const.language.RSC93}</span>
		</button>
	`;
}

function createSubOptionExecuteMethods(id) {
	if(id == undefined) {
		return '';
	}

	// Lanzar = RSC2608
	// Crear proyecto = RSC455
	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC2608}">
			${stcmbackend.svg.gear}
			<span class="ml-1">${pf.const.language.RSC2608}</span>
		</button>
	`;
}

function createSubOptionGetResults(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC454}">
			${stcmbackend.svg.cpu}
			<span class="ml-1">${pf.const.language.RSC454}</span>
		</button>
	`;
}

function createSubOptionGetReport(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC48}" disabled>
			${stcmbackend.svg.fileEarmarkText}
			<span class="ml-1">${pf.const.language.RSC48}</span>
		</button>
	`;
}

function createSubOptionGetLinks(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC2746}" disabled>
			${stcmbackend.svg.link}
			<span class="ml-1">${pf.const.language.RSC2746}</span>
		</button>
	`;
}

function createSubOptionFilterClabe(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC360}" disabled>
			${stcmbackend.svg.creditCard}
			<span class="ml-1">${pf.const.language.RSC360}</span>
		</button>
	`;
}

function createSubOptionViewExported(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC1772}" disabled>
			${stcmbackend.svg.calendarPlusWithoutColor}
			<span class="ml-1">${pf.const.language.RSC1772}</span>
		</button>
	`;
}

function createSubOptionHideExported(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-none align-items-center ma-le-5" title="${pf.const.language.RSC1773}" disabled>
			${stcmbackend.svg.calendarMinusWithoutColor}
			<span class="ml-1">${pf.const.language.RSC1773}</span>
		</button>
	`;
}

function createSubOptionUnmark(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5" title="${pf.const.language.RSC378}">
			${stcmbackend.svg.square}
			<span class="d-none d-xl-inline">${pf.const.language.RSC378}</span>
		</button>
	`;
}

function createSubOptionMark(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5" title="${pf.const.language.RSC379}">
			${stcmbackend.svg.checkSquare}
			<span class="d-none d-xl-inline">${pf.const.language.RSC379}</span>
		</button>
	`;
}

function createSubOptionSendNotif(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC381}">
			${stcmbackend.svg.bell}
			<span class="ml-1">${pf.const.language.RSC381}</span>
		</button>
	`;
}

function createSubOptionSendEmail(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC1877}" disabled>
			${stcmbackend.svg.envelope}
			<span class="ml-1">${pf.const.language.RSC1877}</span>
		</button>
	`;
}

function createSubOptionSendEmailData(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC2002}" disabled>
			${stcmbackend.svg.fileEarmarkText}
			<span class="ml-1">${pf.const.language.RSC2002}</span>
		</button>
	`;
}

function createSubOptionCopy(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-nav d-flex align-items-center ma-le-5" title="${pf.const.language.RSC445}">
			${stcmbackend.svg.fileEarmarkPlus}
			<span class="ml-1">${pf.const.language.RSC445}</span>
		</button>
	`;
}

function createSubOptionExpandCollapse(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn btn-link text-body text-decoration-none he-36 d-flex align-items-center" data-arrow="left" title="${pf.const.language.RSC988}">
			<span class="mr-2">${pf.const.language.RSC988}</span>
			${stcmbackend.svg.chevronRight}
		</button>
	`;
}

function createSubOptionRunningTXT(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<span id="runingTXT" class="ma-to-7 ma-le-5"></span>
		<button id="${id}" type="button" class="btn ma-le-5" title="">
			${stcmbackend.svg.clipboard}
		</button>
	`;
}

function createSubOptionService(id) {
	if(id == undefined) {
		return '';
	}
	// d-flex
	return `
		<button id="${id}" type="button" class="btn btn-nav d-none align-items-center ma-le-5" title="${pf.const.language.RSC2356}">
			${stcmbackend.svg.bug}
			<span class="ml-1">${pf.const.language.RSC2356}</span>
		</button>
	`;
}

function createSubOptionCheck(id, text) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="form-check form-check-inline pl-2">
			<input id="${id}" type="checkbox" class="form-check-input">
			<label for="${id}" class="form-check-label">${text}</label>
		</div>
	`;
}

function createSubOptionStartEndDateTime(strClassDate, strClarssTime, styleDate, styleTime, suffix = '') {
	return `
		<div class="${strClassDate}" style="${styleDate}">
			<label for="startDate${suffix}">${pf.const.language.RSC116}:</label>
			<input id="startDate${suffix}" type="date" class="form-control he-32">
		</div>

		<div class="${strClarssTime}" style="${styleTime}">
			<label for="startTime${suffix}">${pf.const.language.RSC171}:</label>
			<input id="startTime${suffix}" type="time" class="form-control he-32">
		</div>

		<div class="${strClassDate}" style="${styleDate}">
			<label for="endDate${suffix}">${pf.const.language.RSC117}:</label>
			<input id="endDate${suffix}" type="date" class="form-control he-32">
		</div>

		<div class="${strClarssTime}" style="${styleTime}">
			<label for="endTime${suffix}">${pf.const.language.RSC172}:</label>
			<input id="endTime${suffix}" type="time" class="form-control he-32">
		</div>
	`;
}

function createSubOptionOptionsSelector(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="form-group m-0 pt-0 optionsSelectorStyle">
			<label for="${id}">${pf.const.language.RSC65}:</label>
			<select id="${id}" class="form-control he-32">
				<option value="fechaCobro">${pf.const.language.RSC1945}</option>
				<option value="fechaExported">${pf.const.language.RSC1335}</option>
				<option value="fechaProcesado">${pf.const.language.RSC1946}</option>
			</select>
		</div>
	`;
}

function createSubOptionGroups(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="input-group new-input-style new-input-style-action-page ma-le-5">
			<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC6}" aria-label="Grupos" disabled>
			<div class="input-group-append d-block">
				<button id="searchGroups" type="button" class="btn btn-outline-secondary f-content" data-toggle="modal" data-target="#groupTable">
					${stcmbackend.svg.threeDotsWithoutMargin}
				</button>
			</div>
		</div>
	`;
}

function createSubOptionDistributionListSelector(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="input-group new-input-style new-input-style-action-page ma-le-5">
			<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC12}" aria-label="Listas de difusion" disabled>
			<div class="input-group-append d-block">
				<button id="searchDifusion" type="button" class="btn btn-outline-secondary f-content" data-toggle="modal" data-target="#difusionTable">
					${stcmbackend.svg.threeDotsWithoutMargin}
				</button>
			</div>
		</div>
	`;
}

function createSubOptionUserSender(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="input-group new-input-style new-input-style-action-page ma-le-5">
			<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC68} A" aria-label="Usuario Emisor" disabled>
			<div class="input-group-append d-block">
				<button id="searchIssuingUser" type="button" class="btn btn-outline-secondary f-content" data-toggle="modal" data-target="#userTable">
					${stcmbackend.svg.threeDotsWithoutMargin}
				</button>
			</div>
		</div>
	`;
}

function createSubOptionUserReceiver(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div class="input-group new-input-style new-input-style-action-page ma-le-5">
			<input id="${id}" type="text" class="form-control" placeholder="${pf.const.language.RSC68} B" aria-label="Usuario receptor" disabled>
			<div class="input-group-append d-block">
				<button id="searchReceivingUser" type="button" class="btn btn-outline-secondary f-content" data-toggle="modal" data-target="#userTable" disabled>
					${stcmbackend.svg.threeDotsWithoutMargin}
				</button>
			</div>
		</div>
	`;
}

function createSubOptionDownloadMultimedia(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn d-flex align-items-center ma-le-5" title="${pf.const.language.RSC170}" disabled>
			${stcmbackend.svg.fileEarmarkArrowDown}
			<span class="ml-1">${pf.const.language.RSC170}</span>
		</button>
	`;
}

function createSubOptionTwoPoints(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<div id="selectByType" class="d-none ma-le-5">
			<div class="input-group new-input-style new-input-style-action-page">
				<input id="${id}" type="text" class="form-control ma-to-7" placeholder="${pf.const.language.RSC339}" aria-label="Pregunta" disabled>
				<div class="input-group-append d-block li-he-48">
					<button id="twoPointsSelect" type="button" class="btn btn-outline-secondary" data-toggle="modal" data-target="#twoPointsSelectTable">
						${stcmbackend.svg.threeDotsWithoutMargin}
					</button>
				</div>
			</div>
		</div>
	`;
}

function createSubOptionClose(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn d-flex align-items-center" title="${pf.const.language.RSC2114}">
			${stcmbackend.svg.sendSlash}
			<span class="ml-2">${pf.const.language.RSC2114}</span>
		</button>
	`;
}

function createSubOptionPreview(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="${id}" type="button" class="btn-nav btn ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC85}">
			${stcmbackend.svg.eyeWithoutColor}
			<span class="ml-1">${pf.const.language.RSC85}</span>
		</button>
	`;
}

function createSubOptionAddScreen(id) {
	if(id == undefined) {
		return '';
	}

	return `
		<button id="addImage" type="button" class="btn btn-nav ma-le-5 d-flex align-items-center" title="${pf.const.language.RSC2163}">
			${stcmbackend.svg.plusSquare}
			<span class="ml-1">${pf.const.language.RSC2163}</span>
		</button>
	`;
}

function headerSectionHeight(height = 54, footer = false) {
	$('#wrapper').removeClass('totalTall');

	let nav_sub = height + 'px';
	let header_nav = $('.header-nav').css('height');
	let app_content = parseInt(height) + parseInt(header_nav);

	if(height == 0) {
		$('.nav-sub-options').hide();
	} else {
		$('.nav-sub-options').show();
	}

	if(footer) {
		$('#stickyFooterContainer').removeClass('d-none');
		let footer_nav = $('#stickyFooterContainer').css('height');
		app_content += parseInt(footer_nav);
		let bottom = parseInt(footer_nav) + 20;
		$('#scrollUp').css('bottom', bottom + 'px')
	} else {
		$('#stickyFooterContainer').addClass('d-none');
		$('#scrollUp').css('bottom', '20px')
	}

	// Reducción de Header
	$('.nav-sub-options').css('height', nav_sub);
	// Altura de app-content, cuerpo de la sección
	$('.app-content').css('height', 'calc(100% - ' + app_content + 'px)');
}