/*!
 * Font Awesome Icon Picker
 * https://farbelous.github.io/fontawesome-iconpicker/
 *
 * @author Javi Aguilar, itsjavi.com
 * @license MIT License
 * @see https://github.com/farbelous/fontawesome-iconpicker/blob/master/LICENSE
 */


(function(e) {
    if (typeof define === "function" && define.amd) {
        define([ "jquery" ], e);
    } else {
        e(jQuery);
    }
})(function(j) {
    j.ui = j.ui || {};
    var e = j.ui.version = "1.12.1";
    (function() {
        var r, y = Math.max, x = Math.abs, s = /left|center|right/, i = /top|center|bottom/, f = /[\+\-]\d+(\.[\d]+)?%?/, l = /^\w+/, c = /%$/, a = j.fn.pos;
        function q(e, a, t) {
            return [ parseFloat(e[0]) * (c.test(e[0]) ? a / 100 : 1), parseFloat(e[1]) * (c.test(e[1]) ? t / 100 : 1) ];
        }
        function C(e, a) {
            return parseInt(j.css(e, a), 10) || 0;
        }
        function t(e) {
            var a = e[0];
            if (a.nodeType === 9) {
                return {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: 0,
                        left: 0
                    }
                };
            }
            if (j.isWindow(a)) {
                return {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: e.scrollTop(),
                        left: e.scrollLeft()
                    }
                };
            }
            if (a.preventDefault) {
                return {
                    width: 0,
                    height: 0,
                    offset: {
                        top: a.pageY,
                        left: a.pageX
                    }
                };
            }
            return {
                width: e.outerWidth(),
                height: e.outerHeight(),
                offset: e.offset()
            };
        }
        j.pos = {
            scrollbarWidth: function() {
                if (r !== undefined) {
                    return r;
                }
                var e, a, t = j("<div " + "style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'>" + "<div style='height:100px;width:auto;'></div></div>"), s = t.children()[0];
                j("body").append(t);
                e = s.offsetWidth;
                t.css("overflow", "scroll");
                a = s.offsetWidth;
                if (e === a) {
                    a = t[0].clientWidth;
                }
                t.remove();
                return r = e - a;
            },
            getScrollInfo: function(e) {
                var a = e.isWindow || e.isDocument ? "" : e.element.css("overflow-x"), t = e.isWindow || e.isDocument ? "" : e.element.css("overflow-y"), s = a === "scroll" || a === "auto" && e.width < e.element[0].scrollWidth, r = t === "scroll" || t === "auto" && e.height < e.element[0].scrollHeight;
                return {
                    width: r ? j.pos.scrollbarWidth() : 0,
                    height: s ? j.pos.scrollbarWidth() : 0
                };
            },
            getWithinInfo: function(e) {
                var a = j(e || window), t = j.isWindow(a[0]), s = !!a[0] && a[0].nodeType === 9, r = !t && !s;
                return {
                    element: a,
                    isWindow: t,
                    isDocument: s,
                    offset: r ? j(e).offset() : {
                        left: 0,
                        top: 0
                    },
                    scrollLeft: a.scrollLeft(),
                    scrollTop: a.scrollTop(),
                    width: a.outerWidth(),
                    height: a.outerHeight()
                };
            }
        };
        j.fn.pos = function(h) {
            if (!h || !h.of) {
                return a.apply(this, arguments);
            }
            h = j.extend({}, h);
            var m, p, d, u, T, e, g = j(h.of), b = j.pos.getWithinInfo(h.within), k = j.pos.getScrollInfo(b), w = (h.collision || "flip").split(" "), v = {};
            e = t(g);
            if (g[0].preventDefault) {
                h.at = "left top";
            }
            p = e.width;
            d = e.height;
            u = e.offset;
            T = j.extend({}, u);
            j.each([ "my", "at" ], function() {
                var e = (h[this] || "").split(" "), a, t;
                if (e.length === 1) {
                    e = s.test(e[0]) ? e.concat([ "center" ]) : i.test(e[0]) ? [ "center" ].concat(e) : [ "center", "center" ];
                }
                e[0] = s.test(e[0]) ? e[0] : "center";
                e[1] = i.test(e[1]) ? e[1] : "center";
                a = f.exec(e[0]);
                t = f.exec(e[1]);
                v[this] = [ a ? a[0] : 0, t ? t[0] : 0 ];
                h[this] = [ l.exec(e[0])[0], l.exec(e[1])[0] ];
            });
            if (w.length === 1) {
                w[1] = w[0];
            }
            if (h.at[0] === "right") {
                T.left += p;
            } else if (h.at[0] === "center") {
                T.left += p / 2;
            }
            if (h.at[1] === "bottom") {
                T.top += d;
            } else if (h.at[1] === "center") {
                T.top += d / 2;
            }
            m = q(v.at, p, d);
            T.left += m[0];
            T.top += m[1];
            return this.each(function() {
                var t, e, f = j(this), l = f.outerWidth(), c = f.outerHeight(), a = C(this, "marginLeft"), s = C(this, "marginTop"), r = l + a + C(this, "marginRight") + k.width, i = c + s + C(this, "marginBottom") + k.height, o = j.extend({}, T), n = q(v.my, f.outerWidth(), f.outerHeight());
                if (h.my[0] === "right") {
                    o.left -= l;
                } else if (h.my[0] === "center") {
                    o.left -= l / 2;
                }
                if (h.my[1] === "bottom") {
                    o.top -= c;
                } else if (h.my[1] === "center") {
                    o.top -= c / 2;
                }
                o.left += n[0];
                o.top += n[1];
                t = {
                    marginLeft: a,
                    marginTop: s
                };
                j.each([ "left", "top" ], function(e, a) {
                    if (j.ui.pos[w[e]]) {
                        j.ui.pos[w[e]][a](o, {
                            targetWidth: p,
                            targetHeight: d,
                            elemWidth: l,
                            elemHeight: c,
                            collisionPosition: t,
                            collisionWidth: r,
                            collisionHeight: i,
                            offset: [ m[0] + n[0], m[1] + n[1] ],
                            my: h.my,
                            at: h.at,
                            within: b,
                            elem: f
                        });
                    }
                });
                if (h.using) {
                    e = function(e) {
                        var a = u.left - o.left, t = a + p - l, s = u.top - o.top, r = s + d - c, i = {
                            target: {
                                element: g,
                                left: u.left,
                                top: u.top,
                                width: p,
                                height: d
                            },
                            element: {
                                element: f,
                                left: o.left,
                                top: o.top,
                                width: l,
                                height: c
                            },
                            horizontal: t < 0 ? "left" : a > 0 ? "right" : "center",
                            vertical: r < 0 ? "top" : s > 0 ? "bottom" : "middle"
                        };
                        if (p < l && x(a + t) < p) {
                            i.horizontal = "center";
                        }
                        if (d < c && x(s + r) < d) {
                            i.vertical = "middle";
                        }
                        if (y(x(a), x(t)) > y(x(s), x(r))) {
                            i.important = "horizontal";
                        } else {
                            i.important = "vertical";
                        }
                        h.using.call(this, e, i);
                    };
                }
                f.offset(j.extend(o, {
                    using: e
                }));
            });
        };
        j.ui.pos = {
            _trigger: function(e, a, t, s) {
                if (a.elem) {
                    a.elem.trigger({
                        type: t,
                        position: e,
                        positionData: a,
                        triggered: s
                    });
                }
            },
            fit: {
                left: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "fitLeft");
                    var t = a.within, s = t.isWindow ? t.scrollLeft : t.offset.left, r = t.width, i = e.left - a.collisionPosition.marginLeft, f = s - i, l = i + a.collisionWidth - r - s, c;
                    if (a.collisionWidth > r) {
                        if (f > 0 && l <= 0) {
                            c = e.left + f + a.collisionWidth - r - s;
                            e.left += f - c;
                        } else if (l > 0 && f <= 0) {
                            e.left = s;
                        } else {
                            if (f > l) {
                                e.left = s + r - a.collisionWidth;
                            } else {
                                e.left = s;
                            }
                        }
                    } else if (f > 0) {
                        e.left += f;
                    } else if (l > 0) {
                        e.left -= l;
                    } else {
                        e.left = y(e.left - i, e.left);
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "fitLeft");
                },
                top: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "fitTop");
                    var t = a.within, s = t.isWindow ? t.scrollTop : t.offset.top, r = a.within.height, i = e.top - a.collisionPosition.marginTop, f = s - i, l = i + a.collisionHeight - r - s, c;
                    if (a.collisionHeight > r) {
                        if (f > 0 && l <= 0) {
                            c = e.top + f + a.collisionHeight - r - s;
                            e.top += f - c;
                        } else if (l > 0 && f <= 0) {
                            e.top = s;
                        } else {
                            if (f > l) {
                                e.top = s + r - a.collisionHeight;
                            } else {
                                e.top = s;
                            }
                        }
                    } else if (f > 0) {
                        e.top += f;
                    } else if (l > 0) {
                        e.top -= l;
                    } else {
                        e.top = y(e.top - i, e.top);
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "fitTop");
                }
            },
            flip: {
                left: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "flipLeft");
                    var t = a.within, s = t.offset.left + t.scrollLeft, r = t.width, i = t.isWindow ? t.scrollLeft : t.offset.left, f = e.left - a.collisionPosition.marginLeft, l = f - i, c = f + a.collisionWidth - r - i, o = a.my[0] === "left" ? -a.elemWidth : a.my[0] === "right" ? a.elemWidth : 0, n = a.at[0] === "left" ? a.targetWidth : a.at[0] === "right" ? -a.targetWidth : 0, h = -2 * a.offset[0], m, p;
                    if (l < 0) {
                        m = e.left + o + n + h + a.collisionWidth - r - s;
                        if (m < 0 || m < x(l)) {
                            e.left += o + n + h;
                        }
                    } else if (c > 0) {
                        p = e.left - a.collisionPosition.marginLeft + o + n + h - i;
                        if (p > 0 || x(p) < c) {
                            e.left += o + n + h;
                        }
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "flipLeft");
                },
                top: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "flipTop");
                    var t = a.within, s = t.offset.top + t.scrollTop, r = t.height, i = t.isWindow ? t.scrollTop : t.offset.top, f = e.top - a.collisionPosition.marginTop, l = f - i, c = f + a.collisionHeight - r - i, o = a.my[1] === "top", n = o ? -a.elemHeight : a.my[1] === "bottom" ? a.elemHeight : 0, h = a.at[1] === "top" ? a.targetHeight : a.at[1] === "bottom" ? -a.targetHeight : 0, m = -2 * a.offset[1], p, d;
                    if (l < 0) {
                        d = e.top + n + h + m + a.collisionHeight - r - s;
                        if (d < 0 || d < x(l)) {
                            e.top += n + h + m;
                        }
                    } else if (c > 0) {
                        p = e.top - a.collisionPosition.marginTop + n + h + m - i;
                        if (p > 0 || x(p) < c) {
                            e.top += n + h + m;
                        }
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "flipTop");
                }
            },
            flipfit: {
                left: function() {
                    j.ui.pos.flip.left.apply(this, arguments);
                    j.ui.pos.fit.left.apply(this, arguments);
                },
                top: function() {
                    j.ui.pos.flip.top.apply(this, arguments);
                    j.ui.pos.fit.top.apply(this, arguments);
                }
            }
        };
        (function() {
            var e, a, t, s, r, i = document.getElementsByTagName("body")[0], f = document.createElement("div");
            e = document.createElement(i ? "div" : "body");
            t = {
                visibility: "hidden",
                width: 0,
                height: 0,
                border: 0,
                margin: 0,
                background: "none"
            };
            if (i) {
                j.extend(t, {
                    position: "absolute",
                    left: "-1000px",
                    top: "-1000px"
                });
            }
            for (r in t) {
                e.style[r] = t[r];
            }
            e.appendChild(f);
            a = i || document.documentElement;
            a.insertBefore(e, a.firstChild);
            f.style.cssText = "position: absolute; left: 10.7432222px;";
            s = j(f).offset().left;
            j.support.offsetFractions = s > 10 && s < 11;
            e.innerHTML = "";
            a.removeChild(e);
        })();
    })();
    var a = j.ui.position;
});

(function(e) {
    "use strict";
    if (typeof define === "function" && define.amd) {
        define([ "jquery" ], e);
    } else if (window.jQuery && !window.jQuery.fn.iconpicker) {
        e(window.jQuery);
    }
})(function(c) {
    "use strict";
    var f = {
        isEmpty: function(e) {
            return e === false || e === "" || e === null || e === undefined;
        },
        isEmptyObject: function(e) {
            return this.isEmpty(e) === true || e.length === 0;
        },
        isElement: function(e) {
            return c(e).length > 0;
        },
        isString: function(e) {
            return typeof e === "string" || e instanceof String;
        },
        isArray: function(e) {
            return c.isArray(e);
        },
        inArray: function(e, a) {
            return c.inArray(e, a) !== -1;
        },
        throwError: function(e) {
            throw "Font Awesome Icon Picker Exception: " + e;
        }
    };
    var t = function(e, a) {
        this._id = t._idCounter++;
        this.element = c(e).addClass("iconpicker-element");
        this._trigger("iconpickerCreate", {
            iconpickerValue: this.iconpickerValue
        });
        this.options = c.extend({}, t.defaultOptions, this.element.data(), a);
        this.options.templates = c.extend({}, t.defaultOptions.templates, this.options.templates);
        this.options.originalPlacement = this.options.placement;
        this.container = f.isElement(this.options.container) ? c(this.options.container) : false;
        if (this.container === false) {
            if (this.element.is(".dropdown-toggle")) {
                this.container = c("~ .dropdown-menu:first", this.element);
            } else {
                this.container = this.element.is("input,textarea,button,.btn") ? this.element.parent() : this.element;
            }
        }
        this.container.addClass("iconpicker-container");
        if (this.isDropdownMenu()) {
            this.options.placement = "inline";
        }
        this.input = this.element.is("input,textarea") ? this.element.addClass("iconpicker-input") : false;
        if (this.input === false) {
            this.input = this.container.find(this.options.input);
            if (!this.input.is("input,textarea")) {
                this.input = false;
            }
        }
        this.component = this.isDropdownMenu() ? this.container.parent().find(this.options.component) : this.container.find(this.options.component);
        if (this.component.length === 0) {
            this.component = false;
        } else {
            this.component.find("i").addClass("iconpicker-component");
        }
        this._createPopover();
        this._createIconpicker();
        if (this.getAcceptButton().length === 0) {
            this.options.mustAccept = false;
        }
        if (this.isInputGroup()) {
            this.container.parent().append(this.popover);
        } else {
            this.container.append(this.popover);
        }
        this._bindElementEvents();
        this._bindWindowEvents();
        this.update(this.options.selected);
        if (this.isInline()) {
            this.show();
        }
        this._trigger("iconpickerCreated", {
            iconpickerValue: this.iconpickerValue
        });
    };
    t._idCounter = 0;
    t.defaultOptions = {
        title: false,
        selected: false,
        defaultValue: false,
        placement: "bottom",
        collision: "none",
        animation: true,
        hideOnSelect: false,
        showFooter: false,
        searchInFooter: false,
        mustAccept: false,
        selectedCustomClass: "bg-primary",
        icons: [],
        fullClassFormatter: function(e) {
            return e;
        },
        input: "input,.iconpicker-input",
        inputSearch: false,
        container: false,
        component: ".input-group-addon,.iconpicker-component",
        templates: {
            popover: '<div class="iconpicker-popover popover"><div class="arrow"></div>' + '<div class="popover-title"></div><div class="popover-content"></div></div>',
            footer: '<div class="popover-footer"></div>',
            buttons: '<button class="iconpicker-btn iconpicker-btn-cancel btn btn-default btn-sm">Cancel</button>' + ' <button class="iconpicker-btn iconpicker-btn-accept btn btn-primary btn-sm">Accept</button>',
            search: '<input type="search" class="form-control iconpicker-search" placeholder="Type to filter" />',
            iconpicker: '<div class="iconpicker"><div class="iconpicker-items"></div></div>',
            iconpickerItem: '<a role="button" href="javascript:;" class="iconpicker-item"><i></i></a>'
        }
    };
    t.batch = function(e, a) {
        var t = Array.prototype.slice.call(arguments, 2);
        return c(e).each(function() {
            var e = c(this).data("iconpicker");
            if (!!e) {
                e[a].apply(e, t);
            }
        });
    };
    t.prototype = {
        constructor: t,
        options: {},
        _id: 0,
        _trigger: function(e, a) {
            a = a || {};
            this.element.trigger(c.extend({
                type: e,
                iconpickerInstance: this
            }, a));
        },
        _createPopover: function() {
            this.popover = c(this.options.templates.popover);
            var e = this.popover.find(".popover-title");
            if (!!this.options.title) {
                e.append(c('<div class="popover-title-text">' + this.options.title + "</div>"));
            }
            if (this.hasSeparatedSearchInput() && !this.options.searchInFooter) {
                e.append(this.options.templates.search);
            } else if (!this.options.title) {
                e.remove();
            }
            if (this.options.showFooter && !f.isEmpty(this.options.templates.footer)) {
                var a = c(this.options.templates.footer);
                if (this.hasSeparatedSearchInput() && this.options.searchInFooter) {
                    a.append(c(this.options.templates.search));
                }
                if (!f.isEmpty(this.options.templates.buttons)) {
                    a.append(c(this.options.templates.buttons));
                }
                this.popover.append(a);
            }
            if (this.options.animation === true) {
                this.popover.addClass("fade");
            }
            return this.popover;
        },
        _createIconpicker: function() {
            var t = this;
            this.iconpicker = c(this.options.templates.iconpicker);
            var e = function(e) {
                var a = c(this);
                if (a.is("i")) {
                    a = a.parent();
                }
                t._trigger("iconpickerSelect", {
                    iconpickerItem: a,
                    iconpickerValue: t.iconpickerValue
                });
                if (t.options.mustAccept === false) {
                    t.update(a.data("iconpickerValue"));
                    t._trigger("iconpickerSelected", {
                        iconpickerItem: this,
                        iconpickerValue: t.iconpickerValue
                    });
                } else {
                    t.update(a.data("iconpickerValue"), true);
                }
                if (t.options.hideOnSelect && t.options.mustAccept === false) {
                    t.hide();
                }
            };
            var a = c(this.options.templates.iconpickerItem);
            var s = [];
            for (var r in this.options.icons) {
                if (typeof this.options.icons[r].title === "string") {
                    var i = a.clone();
                    i.find("i").addClass(this.options.fullClassFormatter(this.options.icons[r].title));
                    i.data("iconpickerValue", this.options.icons[r].title).on("click.iconpicker", e);
                    i.attr("title", "." + this.options.icons[r].title);
                    if (this.options.icons[r].searchTerms.length > 0) {
                        var f = "";
                        for (var l = 0; l < this.options.icons[r].searchTerms.length; l++) {
                            f = f + this.options.icons[r].searchTerms[l] + " ";
                        }
                        i.attr("data-search-terms", f);
                    }
                    s.push(i);
                }
            }
            this.iconpicker.find(".iconpicker-items").append(s);
            this.popover.find(".popover-content").append(this.iconpicker);
            return this.iconpicker;
        },
        _isEventInsideIconpicker: function(e) {
            var a = c(e.target);
            if ((!a.hasClass("iconpicker-element") || a.hasClass("iconpicker-element") && !a.is(this.element)) && a.parents(".iconpicker-popover").length === 0) {
                return false;
            }
            return true;
        },
        _bindElementEvents: function() {
            var a = this;
            this.getSearchInput().on("keyup.iconpicker", function() {
                a.filter(c(this).val().toLowerCase());
            });
            this.getAcceptButton().on("click.iconpicker", function() {
                var e = a.iconpicker.find(".iconpicker-selected").get(0);
                a.update(a.iconpickerValue);
                a._trigger("iconpickerSelected", {
                    iconpickerItem: e,
                    iconpickerValue: a.iconpickerValue
                });
                if (!a.isInline()) {
                    a.hide();
                }
            });
            this.getCancelButton().on("click.iconpicker", function() {
                if (!a.isInline()) {
                    a.hide();
                }
            });
            this.element.on("focus.iconpicker", function(e) {
                a.show();
                e.stopPropagation();
            });
            if (this.hasComponent()) {
                this.component.on("click.iconpicker", function() {
                    a.toggle();
                });
            }
            if (this.hasInput()) {
                this.input.on("keyup.iconpicker", function(e) {
                    if (!f.inArray(e.keyCode, [ 38, 40, 37, 39, 16, 17, 18, 9, 8, 91, 93, 20, 46, 186, 190, 46, 78, 188, 44, 86 ])) {
                        a.update();
                    } else {
                        a._updateFormGroupStatus(a.getValid(this.value) !== false);
                    }
                    if (a.options.inputSearch === true) {
                        a.filter(c(this).val().toLowerCase());
                    }
                });
            }
        },
        _bindWindowEvents: function() {
            var e = c(window.document);
            var a = this;
            var t = ".iconpicker.inst" + this._id;
            c(window).on("resize.iconpicker" + t + " orientationchange.iconpicker" + t, function(e) {
                if (a.popover.hasClass("in")) {
                    a.updatePlacement();
                }
            });
            if (!a.isInline()) {
                e.on("mouseup" + t, function(e) {
                    if (!a._isEventInsideIconpicker(e) && !a.isInline()) {
                        a.hide();
                    }
                });
            }
        },
        _unbindElementEvents: function() {
            this.popover.off(".iconpicker");
            this.element.off(".iconpicker");
            if (this.hasInput()) {
                this.input.off(".iconpicker");
            }
            if (this.hasComponent()) {
                this.component.off(".iconpicker");
            }
            if (this.hasContainer()) {
                this.container.off(".iconpicker");
            }
        },
        _unbindWindowEvents: function() {
            c(window).off(".iconpicker.inst" + this._id);
            c(window.document).off(".iconpicker.inst" + this._id);
        },
        updatePlacement: function(e, a) {
            e = e || this.options.placement;
            this.options.placement = e;
            a = a || this.options.collision;
            a = a === true ? "flip" : a;
            var t = {
                at: "right bottom",
                my: "right top",
                of: this.hasInput() && !this.isInputGroup() ? this.input : this.container,
                collision: a === true ? "flip" : a,
                within: window
            };
            this.popover.removeClass("inline topLeftCorner topLeft top topRight topRightCorner " + "rightTop right rightBottom bottomRight bottomRightCorner " + "bottom bottomLeft bottomLeftCorner leftBottom left leftTop");
            if (typeof e === "object") {
                return this.popover.pos(c.extend({}, t, e));
            }
            switch (e) {
              case "inline":
                {
                    t = false;
                }
                break;

              case "topLeftCorner":
                {
                    t.my = "right bottom";
                    t.at = "left top";
                }
                break;

              case "topLeft":
                {
                    t.my = "left bottom";
                    t.at = "left top";
                }
                break;

              case "top":
                {
                    t.my = "center bottom";
                    t.at = "center top";
                }
                break;

              case "topRight":
                {
                    t.my = "right bottom";
                    t.at = "right top";
                }
                break;

              case "topRightCorner":
                {
                    t.my = "left bottom";
                    t.at = "right top";
                }
                break;

              case "rightTop":
                {
                    t.my = "left bottom";
                    t.at = "right center";
                }
                break;

              case "right":
                {
                    t.my = "left center";
                    t.at = "right center";
                }
                break;

              case "rightBottom":
                {
                    t.my = "left top";
                    t.at = "right center";
                }
                break;

              case "bottomRightCorner":
                {
                    t.my = "left top";
                    t.at = "right bottom";
                }
                break;

              case "bottomRight":
                {
                    t.my = "right top";
                    t.at = "right bottom";
                }
                break;

              case "bottom":
                {
                    t.my = "center top";
                    t.at = "center bottom";
                }
                break;

              case "bottomLeft":
                {
                    t.my = "left top";
                    t.at = "left bottom";
                }
                break;

              case "bottomLeftCorner":
                {
                    t.my = "right top";
                    t.at = "left bottom";
                }
                break;

              case "leftBottom":
                {
                    t.my = "right top";
                    t.at = "left center";
                }
                break;

              case "left":
                {
                    t.my = "right center";
                    t.at = "left center";
                }
                break;

              case "leftTop":
                {
                    t.my = "right bottom";
                    t.at = "left center";
                }
                break;

              default:
                {
                    return false;
                }
                break;
            }
            this.popover.css({
                display: this.options.placement === "inline" ? "" : "block"
            });
            if (t !== false) {
                this.popover.pos(t).css("maxWidth", c(window).width() - this.container.offset().left - 5);
            } else {
                this.popover.css({
                    top: "auto",
                    right: "auto",
                    bottom: "auto",
                    left: "auto",
                    maxWidth: "none"
                });
            }
            this.popover.addClass(this.options.placement);
            return true;
        },
        _updateComponents: function() {
            this.iconpicker.find(".iconpicker-item.iconpicker-selected").removeClass("iconpicker-selected " + this.options.selectedCustomClass);
            if (this.iconpickerValue) {
                this.iconpicker.find("." + this.options.fullClassFormatter(this.iconpickerValue).replace(/ /g, ".")).parent().addClass("iconpicker-selected " + this.options.selectedCustomClass);
            }
            if (this.hasComponent()) {
                var e = this.component.find("i");
                if (e.length > 0) {
                    e.attr("class", this.options.fullClassFormatter(this.iconpickerValue));
                } else {
                    this.component.html(this.getHtml());
                }
            }
        },
        _updateFormGroupStatus: function(e) {
            if (this.hasInput()) {
                if (e !== false) {
                    this.input.parents(".form-group:first").removeClass("has-error");
                } else {
                    this.input.parents(".form-group:first").addClass("has-error");
                }
                return true;
            }
            return false;
        },
        getValid: function(e) {
            if (!f.isString(e)) {
                e = "";
            }
            var a = e === "";
            e = c.trim(e);
            var t = false;
            for (var s = 0; s < this.options.icons.length; s++) {
                if (this.options.icons[s].title === e) {
                    t = true;
                    break;
                }
            }
            if (t || a) {
                return e;
            }
            return false;
        },
        setValue: function(e) {
            var a = this.getValid(e);
            if (a !== false) {
                this.iconpickerValue = a;
                this._trigger("iconpickerSetValue", {
                    iconpickerValue: a
                });
                return this.iconpickerValue;
            } else {
                this._trigger("iconpickerInvalid", {
                    iconpickerValue: e
                });
                return false;
            }
        },
        getHtml: function() {
            return '<i class="' + this.options.fullClassFormatter(this.iconpickerValue) + '"></i>';
        },
        setSourceValue: function(e) {
            e = this.setValue(e);
            if (e !== false && e !== "") {
                if (this.hasInput()) {
                    this.input.val(this.iconpickerValue);
                } else {
                    this.element.data("iconpickerValue", this.iconpickerValue);
                }
                this._trigger("iconpickerSetSourceValue", {
                    iconpickerValue: e
                });
            }
            return e;
        },
        getSourceValue: function(e) {
            e = e || this.options.defaultValue;
            var a = e;
            if (this.hasInput()) {
                a = this.input.val();
            } else {
                a = this.element.data("iconpickerValue");
            }
            if (a === undefined || a === "" || a === null || a === false) {
                a = e;
            }
            return a;
        },
        hasInput: function() {
            return this.input !== false;
        },
        isInputSearch: function() {
            return this.hasInput() && this.options.inputSearch === true;
        },
        isInputGroup: function() {
            return this.container.is(".input-group");
        },
        isDropdownMenu: function() {
            return this.container.is(".dropdown-menu");
        },
        hasSeparatedSearchInput: function() {
            return this.options.templates.search !== false && !this.isInputSearch();
        },
        hasComponent: function() {
            return this.component !== false;
        },
        hasContainer: function() {
            return this.container !== false;
        },
        getAcceptButton: function() {
            return this.popover.find(".iconpicker-btn-accept");
        },
        getCancelButton: function() {
            return this.popover.find(".iconpicker-btn-cancel");
        },
        getSearchInput: function() {
            return this.popover.find(".iconpicker-search");
        },
        filter: function(r) {
            if (f.isEmpty(r)) {
                this.iconpicker.find(".iconpicker-item").show();
                return c(false);
            } else {
                var i = [];
                this.iconpicker.find(".iconpicker-item").each(function() {
                    var e = c(this);
                    var a = e.attr("title").toLowerCase();
                    var t = e.attr("data-search-terms") ? e.attr("data-search-terms").toLowerCase() : "";
                    a = a + " " + t;
                    var s = false;
                    try {
                        s = new RegExp("(^|\\W)" + r, "g");
                    } catch (e) {
                        s = false;
                    }
                    if (s !== false && a.match(s)) {
                        i.push(e);
                        e.show();
                    } else {
                        e.hide();
                    }
                });
                return i;
            }
        },
        show: function() {
            if (this.popover.hasClass("in")) {
                return false;
            }
            c.iconpicker.batch(c(".iconpicker-popover.in:not(.inline)").not(this.popover), "hide");
            this._trigger("iconpickerShow", {
                iconpickerValue: this.iconpickerValue
            });
            this.updatePlacement();
            this.popover.addClass("in");
            setTimeout(c.proxy(function() {
                this.popover.css("display", this.isInline() ? "" : "block");
                this._trigger("iconpickerShow", {
                    iconpickerValue: this.iconpickerValue
                });
            }, this), this.options.animation ? 300 : 1);
        },
        hide: function() {
            if (!this.popover.hasClass("in")) {
                return false;
            }
            this._trigger("iconpickerHide", {
                iconpickerValue: this.iconpickerValue
            });
            this.popover.removeClass("in");
            setTimeout(c.proxy(function() {
                this.popover.css("display", "none");
                this.getSearchInput().val("");
                this.filter("");
                this._trigger("iconpickerHidden", {
                    iconpickerValue: this.iconpickerValue
                });
            }, this), this.options.animation ? 300 : 1);
        },
        toggle: function() {
            if (this.popover.is(":visible")) {
                this.hide();
            } else {
                this.show(true);
            }
        },
        update: function(e, a) {
            e = e ? e : this.getSourceValue(this.iconpickerValue);
            this._trigger("iconpickerUpdate", {
                iconpickerValue: this.iconpickerValue
            });
            if (a === true) {
                e = this.setValue(e);
            } else {
                e = this.setSourceValue(e);
                this._updateFormGroupStatus(e !== false);
            }
            if (e !== false) {
                this._updateComponents();
            }
            this._trigger("iconpickerUpdated", {
                iconpickerValue: this.iconpickerValue
            });
            return e;
        },
        destroy: function() {
            this._trigger("iconpickerDestroy", {
                iconpickerValue: this.iconpickerValue
            });
            this.element.removeData("iconpicker").removeData("iconpickerValue").removeClass("iconpicker-element");
            this._unbindElementEvents();
            this._unbindWindowEvents();
            c(this.popover).remove();
            this._trigger("iconpickerDestroyed", {
                iconpickerValue: this.iconpickerValue
            });
        },
        disable: function() {
            if (this.hasInput()) {
                this.input.prop("disabled", true);
                return true;
            }
            return false;
        },
        enable: function() {
            if (this.hasInput()) {
                this.input.prop("disabled", false);
                return true;
            }
            return false;
        },
        isDisabled: function() {
            if (this.hasInput()) {
                return this.input.prop("disabled") === true;
            }
            return false;
        },
        isInline: function() {
            return this.options.placement === "inline" || this.popover.hasClass("inline");
        }
    };
    c.iconpicker = t;
    c.fn.iconpicker = function(a) {
        return this.each(function() {
            var e = c(this);
            if (!e.data("iconpicker")) {
                e.data("iconpicker", new t(this, typeof a === "object" ? a : {}));
            }
        });
    };
    t.defaultOptions = c.extend(t.defaultOptions, {
        icons: [ /* {
            title: "fa-light fa-500px",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-accessible-icon",
            searchTerms: [ "accessibility", "handicap", "person", "wheelchair", "wheelchair-alt" ]
        }, */ /* {
            title: "fa-light fa-accusoft",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-acquisitions-incorporated",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, */ {
            title: "fa-light fa-ad",
            searchTerms: []
        }, {
            title: "fa-light fa-address-book",
            searchTerms: []
        }, {
            title: "fa-light fa-address-card",
            searchTerms: []
        }, {
            title: "fa-light fa-adjust",
            searchTerms: [ "contrast" ]
        }, /* {
            title: "fa-light fa-adn",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-adversal",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-affiliatetheme",
            searchTerms: []
        }, */ {
            title: "fa-light fa-air-freshener",
            searchTerms: []
        }, /* {
            title: "fa-light fa-algolia",
            searchTerms: []
        }, */ {
            title: "fa-light fa-align-center",
            searchTerms: [ "middle", "text" ]
        }, {
            title: "fa-light fa-align-justify",
            searchTerms: [ "text" ]
        }, {
            title: "fa-light fa-align-left",
            searchTerms: [ "text" ]
        }, {
            title: "fa-light fa-align-right",
            searchTerms: [ "text" ]
        }, /* {
            title: "fa-light fa-alipay",
            searchTerms: []
        }, */ {
            title: "fa-light fa-allergies",
            searchTerms: [ "freckles", "hand", "intolerances", "pox", "spots" ]
        }, /* {
            title: "fa-light fa-amazon",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-amazon-pay",
            searchTerms: []
        }, */ {
            title: "fa-light fa-ambulance",
            searchTerms: [ "help", "machine", "support", "vehicle" ]
        }, {
            title: "fa-light fa-american-sign-language-interpreting",
            searchTerms: []
        }, /* {
            title: "fa-light fa-amilia",
            searchTerms: []
        }, */ {
            title: "fa-light fa-anchor",
            searchTerms: [ "link" ]
        }, /* {
            title: "fa-light fa-android",
            searchTerms: [ "robot" ]
        }, */ /* {
            title: "fa-light fa-angellist",
            searchTerms: []
        }, */ {
            title: "fa-light fa-angle-double-down",
            searchTerms: [ "arrows" ]
        }, {
            title: "fa-light fa-angle-double-left",
            searchTerms: [ "arrows", "back", "laquo", "previous", "quote" ]
        }, {
            title: "fa-light fa-angle-double-right",
            searchTerms: [ "arrows", "forward", "next", "quote", "raquo" ]
        }, {
            title: "fa-light fa-angle-double-up",
            searchTerms: [ "arrows" ]
        }, {
            title: "fa-light fa-angle-down",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-light fa-angle-left",
            searchTerms: [ "arrow", "back", "previous" ]
        }, {
            title: "fa-light fa-angle-right",
            searchTerms: [ "arrow", "forward", "next" ]
        }, {
            title: "fa-light fa-angle-up",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-light fa-angry",
            searchTerms: [ "disapprove", "emoticon", "face", "mad", "upset" ]
        }, /* {
            title: "fa-light fa-angrycreative",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-angular",
            searchTerms: []
        }, */ {
            title: "fa-light fa-ankh",
            searchTerms: [ "amulet", "copper", "coptic christianity", "copts", "crux ansata", "egyptian", "venus" ]
        }, /* {
            title: "fa-light fa-app-store",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-app-store-ios",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-apper",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-apple",
            searchTerms: [ "food", "fruit", "mac", "osx" ]
        }, */ {
            title: "fa-light fa-apple-alt",
            searchTerms: [ "fall", "food", "fruit", "fuji", "macintosh", "seasonal" ]
        }, /* {
            title: "fa-light fa-apple-pay",
            searchTerms: []
        }, */ {
            title: "fa-light fa-archive",
            searchTerms: [ "box", "package", "storage" ]
        }, {
            title: "fa-light fa-archway",
            searchTerms: [ "arc", "monument", "road", "street" ]
        }, {
            title: "fa-light fa-arrow-alt-circle-down",
            searchTerms: [ "arrow-circle-o-down", "download" ]
        }, {
            title: "fa-light fa-arrow-alt-circle-left",
            searchTerms: [ "arrow-circle-o-left", "back", "previous" ]
        }, {
            title: "fa-light fa-arrow-alt-circle-right",
            searchTerms: [ "arrow-circle-o-right", "forward", "next" ]
        }, {
            title: "fa-light fa-arrow-alt-circle-up",
            searchTerms: [ "arrow-circle-o-up" ]
        }, {
            title: "fa-light fa-arrow-circle-down",
            searchTerms: [ "download" ]
        }, {
            title: "fa-light fa-arrow-circle-left",
            searchTerms: [ "back", "previous" ]
        }, {
            title: "fa-light fa-arrow-circle-right",
            searchTerms: [ "forward", "next" ]
        }, {
            title: "fa-light fa-arrow-circle-up",
            searchTerms: []
        }, {
            title: "fa-light fa-arrow-down",
            searchTerms: [ "download" ]
        }, {
            title: "fa-light fa-arrow-left",
            searchTerms: [ "back", "previous" ]
        }, {
            title: "fa-light fa-arrow-right",
            searchTerms: [ "forward", "next" ]
        }, {
            title: "fa-light fa-arrow-up",
            searchTerms: []
        }, {
            title: "fa-light fa-arrows-alt",
            searchTerms: [ "arrow", "arrows", "bigger", "enlarge", "expand", "fullscreen", "move", "position", "reorder", "resize" ]
        }, {
            title: "fa-light fa-arrows-alt-h",
            searchTerms: [ "arrows-h", "resize" ]
        }, {
            title: "fa-light fa-arrows-alt-v",
            searchTerms: [ "arrows-v", "resize" ]
        }, {
            title: "fa-light fa-assistive-listening-systems",
            searchTerms: []
        }, {
            title: "fa-light fa-asterisk",
            searchTerms: [ "details" ]
        }, /* {
            title: "fa-light fa-asymmetrik",
            searchTerms: []
        }, */ {
            title: "fa-light fa-at",
            searchTerms: [ "e-mail", "email" ]
        }, {
            title: "fa-light fa-atlas",
            searchTerms: [ "book", "directions", "geography", "map", "wayfinding" ]
        }, {
            title: "fa-light fa-atom",
            searchTerms: [ "atheism", "chemistry", "science" ]
        }, /* {
            title: "fa-light fa-audible",
            searchTerms: []
        }, */ {
            title: "fa-light fa-audio-description",
            searchTerms: []
        }, /* {
            title: "fa-light fa-autoprefixer",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-avianex",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-aviato",
            searchTerms: []
        }, */ {
            title: "fa-light fa-award",
            searchTerms: [ "honor", "praise", "prize", "recognition", "ribbon" ]
        }, /* {
            title: "fa-light fa-aws",
            searchTerms: []
        }, */ {
            title: "fa-light fa-backspace",
            searchTerms: [ "command", "delete", "keyboard", "undo" ]
        }, {
            title: "fa-light fa-backward",
            searchTerms: [ "previous", "rewind" ]
        }, {
            title: "fa-light fa-balance-scale",
            searchTerms: [ "balanced", "justice", "legal", "measure", "weight" ]
        }, {
            title: "fa-light fa-ban",
            searchTerms: [ "abort", "ban", "block", "cancel", "delete", "hide", "prohibit", "remove", "stop", "trash" ]
        }, {
            title: "fa-light fa-band-aid",
            searchTerms: [ "bandage", "boo boo", "ouch" ]
        }, /* {
            title: "fa-light fa-bandcamp",
            searchTerms: []
        }, */ {
            title: "fa-light fa-barcode",
            searchTerms: [ "scan" ]
        }, {
            title: "fa-light fa-bars",
            searchTerms: [ "checklist", "drag", "hamburger", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "todo", "ul" ]
        }, {
            title: "fa-light fa-baseball-ball",
            searchTerms: []
        }, {
            title: "fa-light fa-basketball-ball",
            searchTerms: []
        }, {
            title: "fa-light fa-bath",
            searchTerms: []
        }, {
            title: "fa-light fa-battery-empty",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-light fa-battery-full",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-light fa-battery-half",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-light fa-battery-quarter",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-light fa-battery-three-quarters",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-light fa-bed",
            searchTerms: [ "lodging", "sleep", "travel" ]
        }, {
            title: "fa-light fa-beer",
            searchTerms: [ "alcohol", "bar", "beverage", "drink", "liquor", "mug", "stein" ]
        }, /* {
            title: "fa-light fa-behance",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-behance-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-bell",
            searchTerms: [ "alert", "notification", "reminder" ]
        }, {
            title: "fa-light fa-bell-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-bezier-curve",
            searchTerms: [ "curves", "illustrator", "lines", "path", "vector" ]
        }, {
            title: "fa-light fa-bible",
            searchTerms: [ "book", "catholicism", "christianity" ]
        }, {
            title: "fa-light fa-bicycle",
            searchTerms: [ "bike", "gears", "transportation", "vehicle" ]
        }, /* {
            title: "fa-light fa-bimobject",
            searchTerms: []
        }, */ {
            title: "fa-light fa-binoculars",
            searchTerms: []
        }, {
            title: "fa-light fa-birthday-cake",
            searchTerms: []
        }, /* {
            title: "fa-light fa-bitbucket",
            searchTerms: [ "bitbucket-square", "git" ]
        }, */ /* {
            title: "fa-light fa-bitcoin",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-bity",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-black-tie",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-blackberry",
            searchTerms: []
        }, */ {
            title: "fa-light fa-blender",
            searchTerms: []
        }, {
            title: "fa-light fa-blender-phone",
            searchTerms: [ "appliance", "fantasy", "silly" ]
        }, {
            title: "fa-light fa-blind",
            searchTerms: []
        }, /* {
            title: "fa-light fa-blogger",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-blogger-b",
            searchTerms: []
        }, */ {
            title: "fa-light fa-bluetooth",
            searchTerms: []
        }, /* {
            title: "fa-light fa-bluetooth-b",
            searchTerms: []
        }, */ {
            title: "fa-light fa-bold",
            searchTerms: []
        }, {
            title: "fa-light fa-bolt",
            searchTerms: [ "electricity", "lightning", "weather", "zap" ]
        }, {
            title: "fa-light fa-bomb",
            searchTerms: []
        }, {
            title: "fa-light fa-bone",
            searchTerms: []
        }, {
            title: "fa-light fa-bong",
            searchTerms: [ "aparatus", "cannabis", "marijuana", "pipe", "smoke", "smoking" ]
        }, {
            title: "fa-light fa-book",
            searchTerms: [ "documentation", "read" ]
        }, {
            title: "fa-light fa-book-dead",
            searchTerms: [ "Dungeons & Dragons", "crossbones", "d&d", "dark arts", "death", "dnd", "documentation", "evil", "fantasy", "halloween", "holiday", "read", "skull", "spell" ]
        }, {
            title: "fa-light fa-book-open",
            searchTerms: [ "flyer", "notebook", "open book", "pamphlet", "reading" ]
        }, {
            title: "fa-light fa-book-reader",
            searchTerms: [ "library" ]
        }, {
            title: "fa-light fa-bookmark",
            searchTerms: [ "save" ]
        }, {
            title: "fa-light fa-bowling-ball",
            searchTerms: []
        }, {
            title: "fa-light fa-box",
            searchTerms: [ "package" ]
        }, {
            title: "fa-light fa-box-open",
            searchTerms: []
        }, {
            title: "fa-light fa-boxes",
            searchTerms: []
        }, {
            title: "fa-light fa-braille",
            searchTerms: []
        }, {
            title: "fa-light fa-brain",
            searchTerms: [ "cerebellum", "gray matter", "intellect", "medulla oblongata", "mind", "noodle", "wit" ]
        }, {
            title: "fa-light fa-briefcase",
            searchTerms: [ "bag", "business", "luggage", "office", "work" ]
        }, {
            title: "fa-light fa-briefcase-medical",
            searchTerms: [ "health briefcase" ]
        }, {
            title: "fa-light fa-broadcast-tower",
            searchTerms: [ "airwaves", "radio", "waves" ]
        }, {
            title: "fa-light fa-broom",
            searchTerms: [ "clean", "firebolt", "fly", "halloween", "holiday", "nimbus 2000", "quidditch", "sweep", "witch" ]
        }, {
            title: "fa-light fa-brush",
            searchTerms: [ "bristles", "color", "handle", "painting" ]
        }, /* {
            title: "fa-light fa-btc",
            searchTerms: []
        }, */ {
            title: "fa-light fa-bug",
            searchTerms: [ "insect", "report" ]
        }, {
            title: "fa-light fa-building",
            searchTerms: [ "apartment", "business", "company", "office", "work" ]
        }, {
            title: "fa-light fa-bullhorn",
            searchTerms: [ "announcement", "broadcast", "louder", "megaphone", "share" ]
        }, {
            title: "fa-light fa-bullseye",
            searchTerms: [ "target" ]
        }, {
            title: "fa-light fa-burn",
            searchTerms: [ "energy" ]
        }, /* {
            title: "fa-light fa-buromobelexperte",
            searchTerms: []
        }, */ {
            title: "fa-light fa-bus",
            searchTerms: [ "machine", "public transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-bus-alt",
            searchTerms: [ "machine", "public transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-business-time",
            searchTerms: [ "briefcase", "business socks", "clock", "flight of the conchords", "wednesday" ]
        }, /* {
            title: "fa-light fa-buysellads",
            searchTerms: []
        }, */ {
            title: "fa-light fa-calculator",
            searchTerms: []
        }, {
            title: "fa-light fa-calendar",
            searchTerms: [ "calendar-o", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-light fa-calendar-alt",
            searchTerms: [ "calendar", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-light fa-calendar-check",
            searchTerms: [ "accept", "agree", "appointment", "confirm", "correct", "done", "ok", "select", "success", "todo" ]
        }, {
            title: "fa-light fa-calendar-minus",
            searchTerms: [ "delete", "negative", "remove" ]
        }, {
            title: "fa-light fa-calendar-plus",
            searchTerms: [ "add", "create", "new", "positive" ]
        }, {
            title: "fa-light fa-calendar-times",
            searchTerms: [ "archive", "delete", "remove", "x" ]
        }, {
            title: "fa-light fa-camera",
            searchTerms: [ "photo", "picture", "record" ]
        }, {
            title: "fa-light fa-camera-retro",
            searchTerms: [ "photo", "picture", "record" ]
        }, {
            title: "fa-light fa-campground",
            searchTerms: [ "camping", "fall", "outdoors", "seasonal", "tent" ]
        }, {
            title: "fa-light fa-cannabis",
            searchTerms: [ "bud", "chronic", "drugs", "endica", "endo", "ganja", "marijuana", "mary jane", "pot", "reefer", "sativa", "spliff", "weed", "whacky-tabacky" ]
        }, {
            title: "fa-light fa-capsules",
            searchTerms: [ "drugs", "medicine" ]
        }, {
            title: "fa-light fa-car",
            searchTerms: [ "machine", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-car-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-car-battery",
            searchTerms: []
        }, {
            title: "fa-light fa-car-crash",
            searchTerms: []
        }, {
            title: "fa-light fa-car-side",
            searchTerms: []
        }, {
            title: "fa-light fa-caret-down",
            searchTerms: [ "arrow", "dropdown", "menu", "more", "triangle down" ]
        }, {
            title: "fa-light fa-caret-left",
            searchTerms: [ "arrow", "back", "previous", "triangle left" ]
        }, {
            title: "fa-light fa-caret-right",
            searchTerms: [ "arrow", "forward", "next", "triangle right" ]
        }, {
            title: "fa-light fa-caret-up",
            searchTerms: [ "arrow", "triangle up" ]
        }, {
            title: "fa-light fa-caret-square-down",
            searchTerms: [ "caret-square-o-down", "dropdown", "menu", "more" ]
        }, {
            title: "fa-light fa-caret-square-left",
            searchTerms: [ "back", "caret-square-o-left", "previous" ]
        }, {
            title: "fa-light fa-caret-square-right",
            searchTerms: [ "caret-square-o-right", "forward", "next" ]
        }, {
            title: "fa-light fa-caret-square-up",
            searchTerms: [ "caret-square-o-up" ]
        }, {
            title: "fa-light fa-cart-arrow-down",
            searchTerms: [ "shopping" ]
        }, {
            title: "fa-light fa-cart-plus",
            searchTerms: [ "add", "create", "new", "positive", "shopping" ]
        }, {
            title: "fa-light fa-cat",
            searchTerms: [ "feline", "halloween", "holiday", "kitten", "kitty", "meow", "pet" ]
        }, /* {
            title: "fa-light fa-cc-amazon-pay",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-amex",
            searchTerms: [ "amex" ]
        }, */ /* {
            title: "fa-light fa-cc-apple-pay",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-diners-club",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-discover",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-jcb",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-mastercard",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-paypal",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-stripe",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cc-visa",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-centercode",
            searchTerms: []
        }, */ {
            title: "fa-light fa-certificate",
            searchTerms: [ "badge", "star" ]
        }, {
            title: "fa-light fa-chair",
            searchTerms: [ "furniture", "seat" ]
        }, {
            title: "fa-light fa-chalkboard",
            searchTerms: [ "blackboard", "learning", "school", "teaching", "whiteboard", "writing" ]
        }, {
            title: "fa-light fa-chalkboard-teacher",
            searchTerms: [ "blackboard", "instructor", "learning", "professor", "school", "whiteboard", "writing" ]
        }, {
            title: "fa-light fa-charging-station",
            searchTerms: []
        }, {
            title: "fa-light fa-chart-area",
            searchTerms: [ "analytics", "area-chart", "graph" ]
        }, {
            title: "fa-light fa-chart-bar",
            searchTerms: [ "analytics", "bar-chart", "graph" ]
        }, {
            title: "fa-light fa-chart-line",
            searchTerms: [ "activity", "analytics", "dashboard", "graph", "line-chart" ]
        }, {
            title: "fa-light fa-chart-pie",
            searchTerms: [ "analytics", "graph", "pie-chart" ]
        }, {
            title: "fa-light fa-check",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "notice", "notification", "notify", "ok", "select", "success", "tick", "todo", "yes" ]
        }, {
            title: "fa-light fa-check-circle",
            searchTerms: [ "accept", "agree", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-light fa-check-double",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "notice", "notification", "notify", "ok", "select", "success", "tick", "todo" ]
        }, {
            title: "fa-light fa-check-square",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-light fa-check-square",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-light fa-chess",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-bishop",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-board",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-king",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-knight",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-pawn",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-queen",
            searchTerms: []
        }, {
            title: "fa-light fa-chess-rook",
            searchTerms: []
        }, {
            title: "fa-light fa-chevron-circle-down",
            searchTerms: [ "arrow", "dropdown", "menu", "more" ]
        }, {
            title: "fa-light fa-chevron-circle-left",
            searchTerms: [ "arrow", "back", "previous" ]
        }, {
            title: "fa-light fa-chevron-circle-right",
            searchTerms: [ "arrow", "forward", "next" ]
        }, {
            title: "fa-light fa-chevron-circle-up",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-light fa-chevron-down",
            searchTerms: []
        }, {
            title: "fa-light fa-chevron-left",
            searchTerms: [ "back", "bracket", "previous" ]
        }, {
            title: "fa-light fa-chevron-right",
            searchTerms: [ "bracket", "forward", "next" ]
        }, {
            title: "fa-light fa-chevron-up",
            searchTerms: []
        }, {
            title: "fa-light fa-child",
            searchTerms: []
        }, /* {
            title: "fa-light fa-chrome",
            searchTerms: [ "browser" ]
        }, */ {
            title: "fa-light fa-church",
            searchTerms: [ "building", "community", "religion" ]
        }, {
            title: "fa-light fa-circle",
            searchTerms: [ "circle-thin", "dot", "notification" ]
        }, {
            title: "fa-light fa-circle-notch",
            searchTerms: [ "circle-o-notch" ]
        }, {
            title: "fa-light fa-city",
            searchTerms: [ "buildings", "busy", "skyscrapers", "urban", "windows" ]
        }, {
            title: "fa-light fa-clipboard",
            searchTerms: [ "paste" ]
        }, {
            title: "fa-light fa-clipboard-check",
            searchTerms: [ "accept", "agree", "confirm", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-light fa-clipboard-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "intinerary", "ol", "schedule", "todo", "ul" ]
        }, {
            title: "fa-light fa-clock",
            searchTerms: [ "date", "late", "schedule", "timer", "timestamp", "watch" ]
        }, {
            title: "fa-light fa-clone",
            searchTerms: [ "copy", "duplicate" ]
        }, {
            title: "fa-light fa-closed-captioning",
            searchTerms: [ "cc" ]
        }, {
            title: "fa-light fa-cloud",
            searchTerms: [ "save" ]
        }, {
            title: "fa-light fa-cloud-download-alt",
            searchTerms: [ "import" ]
        }, {
            title: "fa-light fa-cloud-meatball",
            searchTerms: []
        }, {
            title: "fa-light fa-cloud-moon",
            searchTerms: [ "crescent", "evening", "halloween", "holiday", "lunar", "night", "sky" ]
        }, {
            title: "fa-light fa-cloud-moon-rain",
            searchTerms: []
        }, {
            title: "fa-light fa-cloud-rain",
            searchTerms: [ "precipitation" ]
        }, {
            title: "fa-light fa-cloud-showers-heavy",
            searchTerms: [ "precipitation", "rain", "storm" ]
        }, {
            title: "fa-light fa-cloud-sun",
            searchTerms: [ "day", "daytime", "fall", "outdoors", "seasonal" ]
        }, {
            title: "fa-light fa-cloud-sun-rain",
            searchTerms: []
        }, {
            title: "fa-light fa-cloud-upload-alt",
            searchTerms: [ "cloud-upload" ]
        }, /* {
            title: "fa-light fa-cloudscale",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cloudsmith",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-cloudversify",
            searchTerms: []
        }, */ {
            title: "fa-light fa-cocktail",
            searchTerms: [ "alcohol", "beverage", "drink" ]
        }, {
            title: "fa-light fa-code",
            searchTerms: [ "brackets", "html" ]
        }, {
            title: "fa-light fa-code-branch",
            searchTerms: [ "branch", "code-fork", "fork", "git", "github", "rebase", "svn", "vcs", "version" ]
        }, /* {
            title: "fa-light fa-codepen",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-codiepie",
            searchTerms: []
        }, */ {
            title: "fa-light fa-coffee",
            searchTerms: [ "beverage", "breakfast", "cafe", "drink", "fall", "morning", "mug", "seasonal", "tea" ]
        }, {
            title: "fa-light fa-cog",
            searchTerms: [ "settings" ]
        }, {
            title: "fa-light fa-cogs",
            searchTerms: [ "gears", "settings" ]
        }, {
            title: "fa-light fa-coins",
            searchTerms: []
        }, {
            title: "fa-light fa-columns",
            searchTerms: [ "dashboard", "panes", "split" ]
        }, {
            title: "fa-light fa-comment",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-light fa-comment-alt",
            searchTerms: [ "bubble", "chat", "commenting", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-light fa-comment-dollar",
            searchTerms: []
        }, {
            title: "fa-light fa-comment-dots",
            searchTerms: []
        }, {
            title: "fa-light fa-comment-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-comments",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-light fa-comments-dollar",
            searchTerms: []
        }, {
            title: "fa-light fa-compact-disc",
            searchTerms: [ "bluray", "cd", "disc", "media" ]
        }, {
            title: "fa-light fa-compass",
            searchTerms: [ "directory", "location", "menu", "safari" ]
        }, {
            title: "fa-light fa-compress",
            searchTerms: [ "collapse", "combine", "contract", "merge", "smaller" ]
        }, {
            title: "fa-light fa-concierge-bell",
            searchTerms: [ "attention", "hotel", "service", "support" ]
        }, /* {
            title: "fa-light fa-connectdevelop",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-contao",
            searchTerms: []
        }, */ {
            title: "fa-light fa-cookie",
            searchTerms: [ "baked good", "chips", "food", "snack", "sweet", "treat" ]
        }, {
            title: "fa-light fa-cookie-bite",
            searchTerms: [ "baked good", "bitten", "chips", "eating", "food", "snack", "sweet", "treat" ]
        }, {
            title: "fa-light fa-copy",
            searchTerms: [ "clone", "duplicate", "file", "files-o" ]
        }, {
            title: "fa-light fa-copyright",
            searchTerms: []
        }, {
            title: "fa-light fa-couch",
            searchTerms: [ "furniture", "sofa" ]
        }, /* {
            title: "fa-light fa-cpanel",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-by",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-nc",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-nc-eu",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-nc-jp",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-nd",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-pd",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-pd-alt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-remix",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-sa",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-sampling",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-sampling-plus",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-share",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-creative-commons-zero",
            searchTerms: []
        }, */ {
            title: "fa-light fa-credit-card",
            searchTerms: [ "buy", "checkout", "credit-card-alt", "debit", "money", "payment", "purchase" ]
        }, /* {
            title: "fa-light fa-critical-role",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, */ {
            title: "fa-light fa-crop",
            searchTerms: [ "design" ]
        }, {
            title: "fa-light fa-crop-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-cross",
            searchTerms: [ "catholicism", "christianity" ]
        }, {
            title: "fa-light fa-crosshairs",
            searchTerms: [ "gpd", "picker", "position" ]
        }, {
            title: "fa-light fa-crow",
            searchTerms: [ "bird", "bullfrog", "fauna", "halloween", "holiday", "toad" ]
        }, {
            title: "fa-light fa-crown",
            searchTerms: []
        }, /* {
            title: "fa-light fa-css3",
            searchTerms: [ "code" ]
        }, */ /* {
            title: "fa-light fa-css3-alt",
            searchTerms: []
        }, */ {
            title: "fa-light fa-cube",
            searchTerms: [ "package" ]
        }, {
            title: "fa-light fa-cubes",
            searchTerms: [ "packages" ]
        }, {
            title: "fa-light fa-cut",
            searchTerms: [ "scissors" ]
        }, /* {
            title: "fa-light fa-cuttlefish",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-d-and-d",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-d-and-d-beyond",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "gaming", "tabletop" ]
        }, */ /* {
            title: "fa-light fa-dashcube",
            searchTerms: []
        }, */ {
            title: "fa-light fa-database",
            searchTerms: []
        }, {
            title: "fa-light fa-deaf",
            searchTerms: []
        }, /* {
            title: "fa-light fa-delicious",
            searchTerms: []
        }, */ {
            title: "fa-light fa-democrat",
            searchTerms: [ "american", "democratic party", "donkey", "election", "left", "left-wing", "liberal", "politics", "usa" ]
        }, /* {
            title: "fa-light fa-deploydog",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-deskpro",
            searchTerms: []
        }, */ {
            title: "fa-light fa-desktop",
            searchTerms: [ "computer", "cpu", "demo", "desktop", "device", "machine", "monitor", "pc", "screen" ]
        }, /* {
            title: "fa-light fa-dev",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-deviantart",
            searchTerms: []
        }, */ {
            title: "fa-light fa-dharmachakra",
            searchTerms: [ "buddhism", "buddhist", "wheel of dharma" ]
        }, {
            title: "fa-light fa-diagnoses",
            searchTerms: []
        }, {
            title: "fa-light fa-dice",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-d20",
            searchTerms: [ "Dungeons & Dragons", "chance", "d&d", "dnd", "fantasy", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-d6",
            searchTerms: [ "Dungeons & Dragons", "chance", "d&d", "dnd", "fantasy", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-five",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-four",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-one",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-six",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-three",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-light fa-dice-two",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, /* {
            title: "fa-light fa-digg",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-digital-ocean",
            searchTerms: []
        }, */ {
            title: "fa-light fa-digital-tachograph",
            searchTerms: []
        }, {
            title: "fa-light fa-directions",
            searchTerms: []
        }, /* {
            title: "fa-light fa-discord",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-discourse",
            searchTerms: []
        }, */ {
            title: "fa-light fa-divide",
            searchTerms: []
        }, {
            title: "fa-light fa-dizzy",
            searchTerms: [ "dazed", "disapprove", "emoticon", "face" ]
        }, {
            title: "fa-light fa-dna",
            searchTerms: [ "double helix", "helix" ]
        }, /* {
            title: "fa-light fa-dochub",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-docker",
            searchTerms: []
        }, */ {
            title: "fa-light fa-dog",
            searchTerms: [ "canine", "fauna", "mammmal", "pet", "pooch", "puppy", "woof" ]
        }, {
            title: "fa-light fa-dollar-sign",
            searchTerms: [ "$", "dollar-sign", "money", "price", "usd" ]
        }, {
            title: "fa-light fa-dolly",
            searchTerms: []
        }, {
            title: "fa-light fa-dolly-flatbed",
            searchTerms: []
        }, {
            title: "fa-light fa-donate",
            searchTerms: [ "generosity", "give" ]
        }, {
            title: "fa-light fa-door-closed",
            searchTerms: []
        }, {
            title: "fa-light fa-door-open",
            searchTerms: []
        }, {
            title: "fa-light fa-dot-circle",
            searchTerms: [ "bullseye", "notification", "target" ]
        }, {
            title: "fa-light fa-dove",
            searchTerms: [ "bird", "fauna", "flying", "peace" ]
        }, {
            title: "fa-light fa-download",
            searchTerms: [ "import" ]
        }, /* {
            title: "fa-light fa-draft2digital",
            searchTerms: []
        }, */ {
            title: "fa-light fa-drafting-compass",
            searchTerms: [ "mechanical drawing", "plot", "plotting" ]
        }, {
            title: "fa-light fa-dragon",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy" ]
        }, {
            title: "fa-light fa-draw-polygon",
            searchTerms: []
        }, /* {
            title: "fa-light fa-dribbble",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-dribbble-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-dropbox",
            searchTerms: []
        }, */ {
            title: "fa-light fa-drum",
            searchTerms: [ "instrument", "music", "percussion", "snare", "sound" ]
        }, {
            title: "fa-light fa-drum-steelpan",
            searchTerms: [ "calypso", "instrument", "music", "percussion", "reggae", "snare", "sound", "steel", "tropical" ]
        }, {
            title: "fa-light fa-drumstick-bite",
            searchTerms: []
        }, /* {
            title: "fa-light fa-drupal",
            searchTerms: []
        }, */ {
            title: "fa-light fa-dumbbell",
            searchTerms: [ "exercise", "gym", "strength", "weight", "weight-lifting" ]
        }, {
            title: "fa-light fa-dungeon",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "door", "entrance", "fantasy", "gate" ]
        }, /* {
            title: "fa-light fa-dyalog",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-earlybirds",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-ebay",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-edge",
            searchTerms: [ "browser", "ie" ]
        }, */ {
            title: "fa-light fa-edit",
            searchTerms: [ "edit", "pen", "pencil", "update", "write" ]
        }, {
            title: "fa-light fa-eject",
            searchTerms: []
        }, /* {
            title: "fa-light fa-elementor",
            searchTerms: []
        }, */ {
            title: "fa-light fa-ellipsis-h",
            searchTerms: [ "dots", "drag", "kebab", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "ul" ]
        }, {
            title: "fa-light fa-ellipsis-v",
            searchTerms: [ "dots", "drag", "kebab", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "ul" ]
        }, /* {
            title: "fa-light fa-ello",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-ember",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-empire",
            searchTerms: []
        }, */ {
            title: "fa-light fa-envelope",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-light fa-envelope-open",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-light fa-envelope-open-text",
            searchTerms: []
        }, {
            title: "fa-light fa-envelope-square",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, /* {
            title: "fa-light fa-envira",
            searchTerms: [ "leaf" ]
        }, */ {
            title: "fa-light fa-equals",
            searchTerms: []
        }, {
            title: "fa-light fa-eraser",
            searchTerms: [ "delete", "remove" ]
        }, /* {
            title: "fa-light fa-erlang",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-ethereum",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-etsy",
            searchTerms: []
        }, */ {
            title: "fa-light fa-euro-sign",
            searchTerms: [ "eur" ]
        }, {
            title: "fa-light fa-exchange-alt",
            searchTerms: [ "arrow", "arrows", "exchange", "reciprocate", "return", "swap", "transfer" ]
        }, {
            title: "fa-light fa-exclamation",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-light fa-exclamation-circle",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-light fa-exclamation-triangle",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-light fa-expand",
            searchTerms: [ "bigger", "enlarge", "resize" ]
        }, {
            title: "fa-light fa-expand-arrows-alt",
            searchTerms: [ "arrows-alt", "bigger", "enlarge", "move", "resize" ]
        }, {
            title: "fa-light fa-expeditedssl",
            searchTerms: []
        }, {
            title: "fa-light fa-external-link-alt",
            searchTerms: [ "external-link", "new", "open" ]
        }, {
            title: "fa-light fa-external-link-square-alt",
            searchTerms: [ "external-link-square", "new", "open" ]
        }, {
            title: "fa-light fa-eye",
            searchTerms: [ "optic", "see", "seen", "show", "sight", "views", "visible" ]
        }, {
            title: "fa-light fa-eye-dropper",
            searchTerms: [ "eyedropper" ]
        }, {
            title: "fa-light fa-eye-slash",
            searchTerms: [ "blind", "hide", "show", "toggle", "unseen", "views", "visible", "visiblity" ]
        }, /* {
            title: "fa-light fa-facebook",
            searchTerms: [ "facebook-official", "social network" ]
        }, */ /* {
            title: "fa-light fa-facebook-f",
            searchTerms: [ "facebook" ]
        }, */ /* {
            title: "fa-light fa-facebook-messenger",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-facebook-square",
            searchTerms: [ "social network" ]
        }, */ /* {
            title: "fa-light fa-fantasy-flight-games",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, */ {
            title: "fa-light fa-fast-backward",
            searchTerms: [ "beginning", "first", "previous", "rewind", "start" ]
        }, {
            title: "fa-light fa-fast-forward",
            searchTerms: [ "end", "last", "next" ]
        }, {
            title: "fa-light fa-fax",
            searchTerms: []
        }, {
            title: "fa-light fa-feather",
            searchTerms: [ "bird", "light", "plucked", "quill" ]
        }, {
            title: "fa-light fa-feather-alt",
            searchTerms: [ "bird", "light", "plucked", "quill" ]
        }, {
            title: "fa-light fa-female",
            searchTerms: [ "human", "person", "profile", "user", "woman" ]
        }, {
            title: "fa-light fa-fighter-jet",
            searchTerms: [ "airplane", "fast", "fly", "goose", "maverick", "plane", "quick", "top gun", "transportation", "travel" ]
        }, {
            title: "fa-light fa-file",
            searchTerms: [ "document", "new", "page", "pdf", "resume" ]
        }, {
            title: "fa-light fa-file-alt",
            searchTerms: [ "document", "file-text", "invoice", "new", "page", "pdf" ]
        }, {
            title: "fa-light fa-file-archive",
            searchTerms: [ ".zip", "bundle", "compress", "compression", "download", "zip" ]
        }, {
            title: "fa-light fa-file-audio",
            searchTerms: []
        }, {
            title: "fa-light fa-file-code",
            searchTerms: []
        }, {
            title: "fa-light fa-file-contract",
            searchTerms: [ "agreement", "binding", "document", "legal", "signature" ]
        }, {
            title: "fa-light fa-file-csv",
            searchTerms: [ "spreadsheets" ]
        }, {
            title: "fa-light fa-file-download",
            searchTerms: []
        }, {
            title: "fa-light fa-file-excel",
            searchTerms: []
        }, {
            title: "fa-light fa-file-export",
            searchTerms: []
        }, {
            title: "fa-light fa-file-image",
            searchTerms: []
        }, {
            title: "fa-light fa-file-import",
            searchTerms: []
        }, {
            title: "fa-light fa-file-invoice",
            searchTerms: [ "bill", "document", "receipt" ]
        }, {
            title: "fa-light fa-file-invoice-dollar",
            searchTerms: [ "$", "bill", "document", "dollar-sign", "money", "receipt", "usd" ]
        }, {
            title: "fa-light fa-file-medical",
            searchTerms: []
        }, {
            title: "fa-light fa-file-medical-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-file-pdf",
            searchTerms: []
        }, {
            title: "fa-light fa-file-powerpoint",
            searchTerms: []
        }, {
            title: "fa-light fa-file-prescription",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-light fa-file-signature",
            searchTerms: [ "John Hancock", "contract", "document", "name" ]
        }, {
            title: "fa-light fa-file-upload",
            searchTerms: []
        }, {
            title: "fa-light fa-file-video",
            searchTerms: []
        }, {
            title: "fa-light fa-file-word",
            searchTerms: []
        }, {
            title: "fa-light fa-fill",
            searchTerms: [ "bucket", "color", "paint", "paint bucket" ]
        }, {
            title: "fa-light fa-fill-drip",
            searchTerms: [ "bucket", "color", "drop", "paint", "paint bucket", "spill" ]
        }, {
            title: "fa-light fa-film",
            searchTerms: [ "movie" ]
        }, {
            title: "fa-light fa-filter",
            searchTerms: [ "funnel", "options" ]
        }, {
            title: "fa-light fa-fingerprint",
            searchTerms: [ "human", "id", "identification", "lock", "smudge", "touch", "unique", "unlock" ]
        }, {
            title: "fa-light fa-fire",
            searchTerms: [ "caliente", "flame", "heat", "hot", "popular" ]
        }, {
            title: "fa-light fa-fire-extinguisher",
            searchTerms: []
        }, /* {
            title: "fa-light fa-firefox",
            searchTerms: [ "browser" ]
        }, */ {
            title: "fa-light fa-first-aid",
            searchTerms: []
        }, /* {
            title: "fa-light fa-first-order",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-first-order-alt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-firstdraft",
            searchTerms: []
        }, */ {
            title: "fa-light fa-fish",
            searchTerms: [ "fauna", "gold", "swimming" ]
        }, {
            title: "fa-light fa-fist-raised",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "hand", "ki", "monk", "resist", "strength", "unarmed combat" ]
        }, {
            title: "fa-light fa-flag",
            searchTerms: [ "country", "notice", "notification", "notify", "pole", "report", "symbol" ]
        }, {
            title: "fa-light fa-flag-checkered",
            searchTerms: [ "notice", "notification", "notify", "pole", "racing", "report", "symbol" ]
        }, {
            title: "fa-light fa-flag-usa",
            searchTerms: [ "betsy ross", "country", "old glory", "stars", "stripes", "symbol" ]
        }, {
            title: "fa-light fa-flask",
            searchTerms: [ "beaker", "experimental", "labs", "science" ]
        }, /* {
            title: "fa-light fa-flickr",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-flipboard",
            searchTerms: []
        }, */ {
            title: "fa-light fa-flushed",
            searchTerms: [ "embarrassed", "emoticon", "face" ]
        }, /* {
            title: "fa-light fa-fly",
            searchTerms: []
        }, */ {
            title: "fa-light fa-folder",
            searchTerms: []
        }, {
            title: "fa-light fa-folder-minus",
            searchTerms: [ "archive", "delete", "negative", "remove" ]
        }, {
            title: "fa-light fa-folder-open",
            searchTerms: []
        }, {
            title: "fa-light fa-folder-plus",
            searchTerms: [ "add", "create", "new", "positive" ]
        }, {
            title: "fa-light fa-font",
            searchTerms: [ "text" ]
        }, {
            title: "fa-light fa-font-awesome",
            searchTerms: [ "meanpath" ]
        }, /* {
            title: "fa-light fa-font-awesome-alt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-fonticons",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-fonticons-fi",
            searchTerms: []
        }, */ {
            title: "fa-light fa-football-ball",
            searchTerms: [ "fall", "pigskin", "seasonal" ]
        }, /* {
            title: "fa-light fa-fort-awesome",
            searchTerms: [ "castle" ]
        }, */ /* {
            title: "fa-light fa-fort-awesome-alt",
            searchTerms: [ "castle" ]
        }, */ /* {
            title: "fa-light fa-forumbee",
            searchTerms: []
        }, */ {
            title: "fa-light fa-forward",
            searchTerms: [ "forward", "next" ]
        }, /* {
            title: "fa-light fa-foursquare",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-free-code-camp",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-freebsd",
            searchTerms: []
        }, */ {
            title: "fa-light fa-frog",
            searchTerms: [ "amphibian", "bullfrog", "fauna", "hop", "kermit", "kiss", "prince", "ribbit", "toad", "wart" ]
        }, {
            title: "fa-light fa-frown",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, {
            title: "fa-light fa-frown-open",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, /* {
            title: "fa-light fa-fulcrum",
            searchTerms: []
        }, */ {
            title: "fa-light fa-funnel-dollar",
            searchTerms: []
        }, {
            title: "fa-light fa-futbol",
            searchTerms: [ "ball", "football", "soccer" ]
        }, /* {
            title: "fa-light fa-galactic-republic",
            searchTerms: [ "politics", "star wars" ]
        }, */ /* {
            title: "fa-light fa-galactic-senate",
            searchTerms: [ "star wars" ]
        }, */ {
            title: "fa-light fa-gamepad",
            searchTerms: [ "controller" ]
        }, {
            title: "fa-light fa-gas-pump",
            searchTerms: []
        }, {
            title: "fa-light fa-gavel",
            searchTerms: [ "hammer", "judge", "lawyer", "opinion" ]
        }, {
            title: "fa-light fa-gem",
            searchTerms: [ "diamond" ]
        }, {
            title: "fa-light fa-genderless",
            searchTerms: []
        }, /* {
            title: "fa-light fa-get-pocket",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-gg",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-gg-circle",
            searchTerms: []
        }, */ {
            title: "fa-light fa-ghost",
            searchTerms: [ "apparition", "blinky", "clyde", "floating", "halloween", "holiday", "inky", "pinky", "spirit" ]
        }, {
            title: "fa-light fa-gift",
            searchTerms: [ "generosity", "giving", "party", "present", "wrapped" ]
        }, /* {
            title: "fa-light fa-git",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-git-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-github",
            searchTerms: [ "octocat" ]
        }, */ /* {
            title: "fa-light fa-github-alt",
            searchTerms: [ "octocat" ]
        }, */ /* {
            title: "fa-light fa-github-square",
            searchTerms: [ "octocat" ]
        }, */ /* {
            title: "fa-light fa-gitkraken",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-gitlab",
            searchTerms: [ "Axosoft" ]
        }, */ /* {
            title: "fa-light fa-gitter",
            searchTerms: []
        }, */ {
            title: "fa-light fa-glass-martini",
            searchTerms: [ "alcohol", "bar", "beverage", "drink", "glass", "liquor", "martini" ]
        }, {
            title: "fa-light fa-glass-martini-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-glasses",
            searchTerms: [ "foureyes", "hipster", "nerd", "reading", "sight", "spectacles" ]
        }, /* {
            title: "fa-light fa-glide",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-glide-g",
            searchTerms: []
        }, */ {
            title: "fa-light fa-globe",
            searchTerms: [ "all", "coordinates", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-light fa-globe-africa",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-light fa-globe-americas",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-light fa-globe-asia",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, /* {
            title: "fa-light fa-gofore",
            searchTerms: []
        }, */ {
            title: "fa-light fa-golf-ball",
            searchTerms: []
        }, /* {
            title: "fa-light fa-goodreads",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-goodreads-g",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-google",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-google-drive",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-google-play",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-google-plus",
            searchTerms: [ "google-plus-circle", "google-plus-official" ]
        }, */ /* {
            title: "fa-light fa-google-plus-g",
            searchTerms: [ "google-plus", "social network" ]
        }, */ /* {
            title: "fa-light fa-google-plus-square",
            searchTerms: [ "social network" ]
        }, */ /* {
            title: "fa-light fa-google-wallet",
            searchTerms: []
        }, */ {
            title: "fa-light fa-gopuram",
            searchTerms: [ "building", "entrance", "hinduism", "temple", "tower" ]
        }, {
            title: "fa-light fa-graduation-cap",
            searchTerms: [ "learning", "school", "student" ]
        }, /* {
            title: "fa-light fa-gratipay",
            searchTerms: [ "favorite", "heart", "like", "love" ]
        }, */ /* {
            title: "fa-light fa-grav",
            searchTerms: []
        }, */ {
            title: "fa-light fa-greater-than",
            searchTerms: []
        }, {
            title: "fa-light fa-greater-than-equal",
            searchTerms: []
        }, {
            title: "fa-light fa-grimace",
            searchTerms: [ "cringe", "emoticon", "face" ]
        }, {
            title: "fa-light fa-grin",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-light fa-grin-alt",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-light fa-grin-beam",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-light fa-grin-beam-sweat",
            searchTerms: [ "emoticon", "face", "smile" ]
        }, {
            title: "fa-light fa-grin-hearts",
            searchTerms: [ "emoticon", "face", "love", "smile" ]
        }, {
            title: "fa-light fa-grin-squint",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-light fa-grin-squint-tears",
            searchTerms: [ "emoticon", "face", "happy", "smile" ]
        }, {
            title: "fa-light fa-grin-stars",
            searchTerms: [ "emoticon", "face", "star-struck" ]
        }, {
            title: "fa-light fa-grin-tears",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-grin-tongue",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-grin-tongue-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-grin-tongue-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-grin-wink",
            searchTerms: [ "emoticon", "face", "flirt", "laugh", "smile" ]
        }, {
            title: "fa-light fa-grip-horizontal",
            searchTerms: [ "affordance", "drag", "drop", "grab", "handle" ]
        }, {
            title: "fa-light fa-grip-vertical",
            searchTerms: [ "affordance", "drag", "drop", "grab", "handle" ]
        }, /* {
            title: "fa-light fa-gripfire",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-grunt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-gulp",
            searchTerms: []
        }, */ {
            title: "fa-light fa-h-square",
            searchTerms: [ "hospital", "hotel" ]
        }, /* {
            title: "fa-light fa-hacker-news",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-hacker-news-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-hackerrank",
            searchTerms: []
        }, */ {
            title: "fa-light fa-hammer",
            searchTerms: [ "admin", "fix", "repair", "settings", "tool" ]
        }, {
            title: "fa-light fa-hamsa",
            searchTerms: [ "amulet", "christianity", "islam", "jewish", "judaism", "muslim", "protection" ]
        }, {
            title: "fa-light fa-hand-holding",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-holding-heart",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-holding-usd",
            searchTerms: [ "$", "dollar sign", "donation", "giving", "money", "price" ]
        }, {
            title: "fa-light fa-hand-lizard",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-paper",
            searchTerms: [ "stop" ]
        }, {
            title: "fa-light fa-hand-peace",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-point-down",
            searchTerms: [ "finger", "hand-o-down", "point" ]
        }, {
            title: "fa-light fa-hand-point-left",
            searchTerms: [ "back", "finger", "hand-o-left", "left", "point", "previous" ]
        }, {
            title: "fa-light fa-hand-point-right",
            searchTerms: [ "finger", "forward", "hand-o-right", "next", "point", "right" ]
        }, {
            title: "fa-light fa-hand-point-up",
            searchTerms: [ "finger", "hand-o-up", "point" ]
        }, {
            title: "fa-light fa-hand-pointer",
            searchTerms: [ "select" ]
        }, {
            title: "fa-light fa-hand-rock",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-scissors",
            searchTerms: []
        }, {
            title: "fa-light fa-hand-spock",
            searchTerms: []
        }, {
            title: "fa-light fa-hands",
            searchTerms: []
        }, {
            title: "fa-light fa-hands-helping",
            searchTerms: [ "aid", "assistance", "partnership", "volunteering" ]
        }, {
            title: "fa-light fa-handshake",
            searchTerms: [ "greeting", "partnership" ]
        }, {
            title: "fa-light fa-hanukiah",
            searchTerms: [ "candle", "hanukkah", "jewish", "judaism", "light" ]
        }, {
            title: "fa-light fa-hashtag",
            searchTerms: []
        }, {
            title: "fa-light fa-hat-wizard",
            searchTerms: [ "Dungeons & Dragons", "buckle", "cloth", "clothing", "d&d", "dnd", "fantasy", "halloween", "holiday", "mage", "magic", "pointy", "witch" ]
        }, /* {
            title: "fa-light fa-haykal",
            searchTerms: [ "bahai", "bahá'í", "star" ]
        }, */ {
            title: "fa-light fa-hdd",
            searchTerms: [ "cpu", "hard drive", "harddrive", "machine", "save", "storage" ]
        }, {
            title: "fa-light fa-heading",
            searchTerms: [ "header" ]
        }, {
            title: "fa-light fa-headphones",
            searchTerms: [ "audio", "listen", "music", "sound", "speaker" ]
        }, {
            title: "fa-light fa-headphones-alt",
            searchTerms: [ "audio", "listen", "music", "sound", "speaker" ]
        }, {
            title: "fa-light fa-headset",
            searchTerms: [ "audio", "gamer", "gaming", "listen", "live chat", "microphone", "shot caller", "sound", "support", "telemarketer" ]
        }, {
            title: "fa-light fa-heart",
            searchTerms: [ "favorite", "like", "love" ]
        }, {
            title: "fa-light fa-heartbeat",
            searchTerms: [ "ekg", "lifeline", "vital signs" ]
        }, {
            title: "fa-light fa-helicopter",
            searchTerms: [ "airwolf", "apache", "chopper", "flight", "fly" ]
        }, {
            title: "fa-light fa-highlighter",
            searchTerms: [ "edit", "marker", "sharpie", "update", "write" ]
        }, {
            title: "fa-light fa-hiking",
            searchTerms: [ "activity", "backpack", "fall", "fitness", "outdoors", "seasonal", "walking" ]
        }, {
            title: "fa-light fa-hippo",
            searchTerms: [ "fauna", "hungry", "mammmal" ]
        }, /* {
            title: "fa-light fa-hips",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-hire-a-helper",
            searchTerms: []
        }, */ {
            title: "fa-light fa-history",
            searchTerms: []
        }, {
            title: "fa-light fa-hockey-puck",
            searchTerms: []
        }, {
            title: "fa-light fa-home",
            searchTerms: [ "house", "main" ]
        }, /* {
            title: "fa-light fa-hooli",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-hornbill",
            searchTerms: []
        }, */ {
            title: "fa-light fa-horse",
            searchTerms: [ "equus", "fauna", "mammmal", "neigh" ]
        }, {
            title: "fa-light fa-hospital",
            searchTerms: [ "building", "emergency room", "medical center" ]
        }, {
            title: "fa-light fa-hospital-symbol",
            searchTerms: []
        }, {
            title: "fa-light fa-hot-tub",
            searchTerms: []
        }, {
            title: "fa-light fa-hotel",
            searchTerms: [ "building", "lodging" ]
        }, /* {
            title: "fa-light fa-hotjar",
            searchTerms: []
        }, */ {
            title: "fa-light fa-hourglass",
            searchTerms: []
        }, {
            title: "fa-light fa-hourglass-end",
            searchTerms: []
        }, {
            title: "fa-light fa-hourglass-half",
            searchTerms: []
        }, {
            title: "fa-light fa-hourglass-start",
            searchTerms: []
        }, {
            title: "fa-light fa-house-damage",
            searchTerms: [ "devastation", "home" ]
        }, /* {
            title: "fa-light fa-houzz",
            searchTerms: []
        }, */ {
            title: "fa-light fa-hryvnia",
            searchTerms: [ "money" ]
        }, /* {
            title: "fa-light fa-html5",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-hubspot",
            searchTerms: []
        }, */ {
            title: "fa-light fa-i-cursor",
            searchTerms: []
        }, {
            title: "fa-light fa-id-badge",
            searchTerms: []
        }, {
            title: "fa-light fa-id-card",
            searchTerms: [ "document", "identification", "issued" ]
        }, {
            title: "fa-light fa-id-card-alt",
            searchTerms: [ "demographics" ]
        }, {
            title: "fa-light fa-image",
            searchTerms: [ "album", "photo", "picture" ]
        }, {
            title: "fa-light fa-images",
            searchTerms: [ "album", "photo", "picture" ]
        }, /* {
            title: "fa-light fa-imdb",
            searchTerms: []
        }, */ {
            title: "fa-light fa-inbox",
            searchTerms: []
        }, {
            title: "fa-light fa-indent",
            searchTerms: []
        }, {
            title: "fa-light fa-industry",
            searchTerms: [ "factory", "manufacturing" ]
        }, {
            title: "fa-light fa-infinity",
            searchTerms: []
        }, {
            title: "fa-light fa-info",
            searchTerms: [ "details", "help", "information", "more" ]
        }, {
            title: "fa-light fa-info-circle",
            searchTerms: [ "details", "help", "information", "more" ]
        }, /* {
            title: "fa-light fa-instagram",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-internet-explorer",
            searchTerms: [ "browser", "ie" ]
        }, */ /* {
            title: "fa-light fa-ioxhost",
            searchTerms: []
        }, */ {
            title: "fa-light fa-italic",
            searchTerms: [ "italics" ]
        }, /* {
            title: "fa-light fa-itunes",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-itunes-note",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-java",
            searchTerms: []
        }, */ {
            title: "fa-light fa-jedi",
            searchTerms: [ "star wars" ]
        }, /* {
            title: "fa-light fa-jedi-order",
            searchTerms: [ "star wars" ]
        }, */ /* {
            title: "fa-light fa-jenkins",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-joget",
            searchTerms: []
        }, */ {
            title: "fa-light fa-joint",
            searchTerms: [ "blunt", "cannabis", "doobie", "drugs", "marijuana", "roach", "smoke", "smoking", "spliff" ]
        }, /* {
            title: "fa-light fa-joomla",
            searchTerms: []
        }, */ {
            title: "fa-light fa-journal-whills",
            searchTerms: [ "book", "jedi", "star wars", "the force" ]
        }, /* {
            title: "fa-light fa-js",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-js-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-jsfiddle",
            searchTerms: []
        }, */ {
            title: "fa-light fa-kaaba",
            searchTerms: [ "building", "cube", "islam", "muslim" ]
        }, /* {
            title: "fa-light fa-kaggle",
            searchTerms: []
        }, */ {
            title: "fa-light fa-key",
            searchTerms: [ "password", "unlock" ]
        }, /* {
            title: "fa-light fa-keybase",
            searchTerms: []
        }, */ {
            title: "fa-light fa-keyboard",
            searchTerms: [ "input", "type" ]
        }, /* {
            title: "fa-light fa-keycdn",
            searchTerms: []
        }, */ {
            title: "fa-light fa-khanda",
            searchTerms: [ "chakkar", "sikh", "sikhism", "sword" ]
        }, /* {
            title: "fa-light fa-kickstarter",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-kickstarter-k",
            searchTerms: []
        }, */ {
            title: "fa-light fa-kiss",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-light fa-kiss-beam",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-light fa-kiss-wink-heart",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-light fa-kiwi-bird",
            searchTerms: [ "bird", "fauna" ]
        }, /* {
            title: "fa-light fa-korvue",
            searchTerms: []
        }, */ {
            title: "fa-light fa-landmark",
            searchTerms: [ "building", "historic", "memoroable", "politics" ]
        }, {
            title: "fa-light fa-language",
            searchTerms: [ "dialect", "idiom", "localize", "speech", "translate", "vernacular" ]
        }, {
            title: "fa-light fa-laptop",
            searchTerms: [ "computer", "cpu", "dell", "demo", "device", "dude you're getting", "mac", "macbook", "machine", "pc" ]
        }, {
            title: "fa-light fa-laptop-code",
            searchTerms: []
        }, /* {
            title: "fa-light fa-laravel",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-lastfm",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-lastfm-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-laugh",
            searchTerms: [ "LOL", "emoticon", "face", "laugh" ]
        }, {
            title: "fa-light fa-laugh-beam",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-laugh-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-laugh-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-light fa-layer-group",
            searchTerms: [ "layers" ]
        }, {
            title: "fa-light fa-leaf",
            searchTerms: [ "eco", "flora", "nature", "plant" ]
        }, /* {
            title: "fa-light fa-leanpub",
            searchTerms: []
        }, */ {
            title: "fa-light fa-lemon",
            searchTerms: [ "food" ]
        }, {
            title: "fa-light fa-less",
            searchTerms: []
        }, {
            title: "fa-light fa-less-than",
            searchTerms: []
        }, {
            title: "fa-light fa-less-than-equal",
            searchTerms: []
        }, {
            title: "fa-light fa-level-down-alt",
            searchTerms: [ "level-down" ]
        }, {
            title: "fa-light fa-level-up-alt",
            searchTerms: [ "level-up" ]
        }, {
            title: "fa-light fa-life-ring",
            searchTerms: [ "support" ]
        }, {
            title: "fa-light fa-lightbulb",
            searchTerms: [ "idea", "inspiration" ]
        }, /* {
            title: "fa-light fa-line",
            searchTerms: []
        }, */ {
            title: "fa-light fa-link",
            searchTerms: [ "chain" ]
        }, /* {
            title: "fa-light fa-linkedin",
            searchTerms: [ "linkedin-square" ]
        }, */ /* {
            title: "fa-light fa-linkedin-in",
            searchTerms: [ "linkedin" ]
        }, */ /* {
            title: "fa-light fa-linode",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-linux",
            searchTerms: [ "tux" ]
        }, */ {
            title: "fa-light fa-lira-sign",
            searchTerms: [ "try", "turkish" ]
        }, {
            title: "fa-light fa-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-light fa-list-alt",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-light fa-list-ol",
            searchTerms: [ "checklist", "list", "numbers", "ol", "todo", "ul" ]
        }, {
            title: "fa-light fa-list-ul",
            searchTerms: [ "checklist", "list", "ol", "todo", "ul" ]
        }, {
            title: "fa-light fa-location-arrow",
            searchTerms: [ "address", "coordinates", "gps", "location", "map", "place", "where" ]
        }, {
            title: "fa-light fa-lock",
            searchTerms: [ "admin", "protect", "security" ]
        }, {
            title: "fa-light fa-lock-open",
            searchTerms: [ "admin", "lock", "open", "password", "protect" ]
        }, {
            title: "fa-light fa-long-arrow-alt-down",
            searchTerms: [ "long-arrow-down" ]
        }, {
            title: "fa-light fa-long-arrow-alt-left",
            searchTerms: [ "back", "long-arrow-left", "previous" ]
        }, {
            title: "fa-light fa-long-arrow-alt-right",
            searchTerms: [ "long-arrow-right" ]
        }, {
            title: "fa-light fa-long-arrow-alt-up",
            searchTerms: [ "long-arrow-up" ]
        }, {
            title: "fa-light fa-low-vision",
            searchTerms: []
        }, {
            title: "fa-light fa-luggage-cart",
            searchTerms: []
        }, /* {
            title: "fa-light fa-lyft",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-magento",
            searchTerms: []
        }, */ {
            title: "fa-light fa-magic",
            searchTerms: [ "autocomplete", "automatic", "mage", "magic", "spell", "witch", "wizard" ]
        }, {
            title: "fa-light fa-magnet",
            searchTerms: []
        }, {
            title: "fa-light fa-mail-bulk",
            searchTerms: []
        }, /* {
            title: "fa-light fa-mailchimp",
            searchTerms: []
        }, */ {
            title: "fa-light fa-male",
            searchTerms: [ "human", "man", "person", "profile", "user" ]
        }, /* {
            title: "fa-light fa-mandalorian",
            searchTerms: []
        }, */ {
            title: "fa-light fa-map",
            searchTerms: [ "coordinates", "location", "paper", "place", "travel" ]
        }, {
            title: "fa-light fa-map-marked",
            searchTerms: [ "address", "coordinates", "destination", "gps", "localize", "location", "map", "paper", "pin", "place", "point of interest", "position", "route", "travel", "where" ]
        }, {
            title: "fa-light fa-map-marked-alt",
            searchTerms: [ "address", "coordinates", "destination", "gps", "localize", "location", "map", "paper", "pin", "place", "point of interest", "position", "route", "travel", "where" ]
        }, {
            title: "fa-light fa-map-marker",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "pin", "place", "position", "travel", "where" ]
        }, {
            title: "fa-light fa-map-marker-alt",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "pin", "place", "position", "travel", "where" ]
        }, {
            title: "fa-light fa-map-pin",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "marker", "place", "position", "travel", "where" ]
        }, {
            title: "fa-light fa-map-signs",
            searchTerms: []
        }, /* {
            title: "fa-light fa-markdown",
            searchTerms: []
        }, */ {
            title: "fa-light fa-marker",
            searchTerms: [ "edit", "sharpie", "update", "write" ]
        }, {
            title: "fa-light fa-mars",
            searchTerms: [ "male" ]
        }, {
            title: "fa-light fa-mars-double",
            searchTerms: []
        }, {
            title: "fa-light fa-mars-stroke",
            searchTerms: []
        }, {
            title: "fa-light fa-mars-stroke-h",
            searchTerms: []
        }, {
            title: "fa-light fa-mars-stroke-v",
            searchTerms: []
        }, {
            title: "fa-light fa-mask",
            searchTerms: [ "costume", "disguise", "halloween", "holiday", "secret", "super hero" ]
        }, /* {
            title: "fa-light fa-mastodon",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-maxcdn",
            searchTerms: []
        }, */ {
            title: "fa-light fa-medal",
            searchTerms: []
        }, /* {
            title: "fa-light fa-medapps",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-medium",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-medium-m",
            searchTerms: []
        }, */ {
            title: "fa-light fa-medkit",
            searchTerms: [ "first aid", "firstaid", "health", "help", "support" ]
        }, /* {
            title: "fa-light fa-medrt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-meetup",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-megaport",
            searchTerms: []
        }, */ {
            title: "fa-light fa-meh",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-light fa-meh-blank",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-light fa-meh-rolling-eyes",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-light fa-memory",
            searchTerms: [ "DIMM", "RAM" ]
        }, {
            title: "fa-light fa-menorah",
            searchTerms: [ "candle", "hanukkah", "jewish", "judaism", "light" ]
        }, {
            title: "fa-light fa-mercury",
            searchTerms: [ "transgender" ]
        }, {
            title: "fa-light fa-meteor",
            searchTerms: []
        }, {
            title: "fa-light fa-microchip",
            searchTerms: [ "cpu", "processor" ]
        }, {
            title: "fa-light fa-microphone",
            searchTerms: [ "record", "sound", "voice" ]
        }, {
            title: "fa-light fa-microphone-alt",
            searchTerms: [ "record", "sound", "voice" ]
        }, {
            title: "fa-light fa-microphone-alt-slash",
            searchTerms: [ "disable", "mute", "record", "sound", "voice" ]
        }, {
            title: "fa-light fa-microphone-slash",
            searchTerms: [ "disable", "mute", "record", "sound", "voice" ]
        }, {
            title: "fa-light fa-microscope",
            searchTerms: []
        }, /* {
            title: "fa-light fa-microsoft",
            searchTerms: []
        }, */ {
            title: "fa-light fa-minus",
            searchTerms: [ "collapse", "delete", "hide", "minify", "negative", "remove", "trash" ]
        }, {
            title: "fa-light fa-minus-circle",
            searchTerms: [ "delete", "hide", "negative", "remove", "trash" ]
        }, {
            title: "fa-light fa-minus-square",
            searchTerms: [ "collapse", "delete", "hide", "minify", "negative", "remove", "trash" ]
        }, /* {
            title: "fa-light fa-mix",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-mixcloud",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-mizuni",
            searchTerms: []
        }, */ {
            title: "fa-light fa-mobile",
            searchTerms: [ "apple", "call", "cell phone", "cellphone", "device", "iphone", "number", "screen", "telephone", "text" ]
        }, {
            title: "fa-light fa-mobile-alt",
            searchTerms: [ "apple", "call", "cell phone", "cellphone", "device", "iphone", "number", "screen", "telephone", "text" ]
        }, /* {
            title: "fa-light fa-modx",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-monero",
            searchTerms: []
        }, */ {
            title: "fa-light fa-money-bill",
            searchTerms: [ "buy", "cash", "checkout", "money", "payment", "price", "purchase" ]
        }, {
            title: "fa-light fa-money-bill-alt",
            searchTerms: [ "buy", "cash", "checkout", "money", "payment", "price", "purchase" ]
        }, {
            title: "fa-light fa-money-bill-wave",
            searchTerms: []
        }, {
            title: "fa-light fa-money-bill-wave-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-money-check",
            searchTerms: [ "bank check", "cheque" ]
        }, {
            title: "fa-light fa-money-check-alt",
            searchTerms: [ "bank check", "cheque" ]
        }, {
            title: "fa-light fa-monument",
            searchTerms: [ "building", "historic", "memoroable" ]
        }, {
            title: "fa-light fa-moon",
            searchTerms: [ "contrast", "crescent", "darker", "lunar", "night" ]
        }, {
            title: "fa-light fa-mortar-pestle",
            searchTerms: [ "crush", "culinary", "grind", "medical", "mix", "spices" ]
        }, {
            title: "fa-light fa-mosque",
            searchTerms: [ "building", "islam", "muslim" ]
        }, {
            title: "fa-light fa-motorcycle",
            searchTerms: [ "bike", "machine", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-mountain",
            searchTerms: []
        }, {
            title: "fa-light fa-mouse-pointer",
            searchTerms: [ "select" ]
        }, {
            title: "fa-light fa-music",
            searchTerms: [ "note", "sound" ]
        }, /* {
            title: "fa-light fa-napster",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-neos",
            searchTerms: []
        }, */ {
            title: "fa-light fa-network-wired",
            searchTerms: []
        }, {
            title: "fa-light fa-neuter",
            searchTerms: []
        }, {
            title: "fa-light fa-newspaper",
            searchTerms: [ "article", "press" ]
        }, /* {
            title: "fa-light fa-nimblr",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-node",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-node-js",
            searchTerms: []
        }, */ {
            title: "fa-light fa-not-equal",
            searchTerms: []
        }, {
            title: "fa-light fa-notes-medical",
            searchTerms: []
        }, /* {
            title: "fa-light fa-npm",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-ns8",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-nutritionix",
            searchTerms: []
        }, */ {
            title: "fa-light fa-object-group",
            searchTerms: [ "design" ]
        }, {
            title: "fa-light fa-object-ungroup",
            searchTerms: [ "design" ]
        }, /* {
            title: "fa-light fa-odnoklassniki",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-odnoklassniki-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-oil-can",
            searchTerms: []
        }, /* {
            title: "fa-light fa-old-republic",
            searchTerms: [ "politics", "star wars" ]
        }, */ {
            title: "fa-light fa-om",
            searchTerms: [ "buddhism", "hinduism", "jainism", "mantra" ]
        }, /* {
            title: "fa-light fa-opencart",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-openid",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-opera",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-optin-monster",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-osi",
            searchTerms: []
        }, */ {
            title: "fa-light fa-otter",
            searchTerms: [ "fauna", "mammmal" ]
        }, {
            title: "fa-light fa-outdent",
            searchTerms: []
        }, /* {
            title: "fa-light fa-page4",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pagelines",
            searchTerms: [ "eco", "flora", "leaf", "leaves", "nature", "plant", "tree" ]
        }, */ {
            title: "fa-light fa-paint-brush",
            searchTerms: []
        }, {
            title: "fa-light fa-paint-roller",
            searchTerms: [ "brush", "painting", "tool" ]
        }, {
            title: "fa-light fa-palette",
            searchTerms: [ "colors", "painting" ]
        }, /* {
            title: "fa-light fa-palfed",
            searchTerms: []
        }, */ {
            title: "fa-light fa-pallet",
            searchTerms: []
        }, {
            title: "fa-light fa-paper-plane",
            searchTerms: []
        }, {
            title: "fa-light fa-paperclip",
            searchTerms: [ "attachment" ]
        }, {
            title: "fa-light fa-parachute-box",
            searchTerms: [ "aid", "assistance", "rescue", "supplies" ]
        }, {
            title: "fa-light fa-paragraph",
            searchTerms: []
        }, {
            title: "fa-light fa-parking",
            searchTerms: []
        }, {
            title: "fa-light fa-passport",
            searchTerms: [ "document", "identification", "issued" ]
        }, {
            title: "fa-light fa-pastafarianism",
            searchTerms: [ "agnosticism", "atheism", "flying spaghetti monster", "fsm" ]
        }, {
            title: "fa-light fa-paste",
            searchTerms: [ "clipboard", "copy" ]
        }, /* {
            title: "fa-light fa-patreon",
            searchTerms: []
        }, */ {
            title: "fa-light fa-pause",
            searchTerms: [ "wait" ]
        }, {
            title: "fa-light fa-pause-circle",
            searchTerms: []
        }, {
            title: "fa-light fa-paw",
            searchTerms: [ "animal", "pet" ]
        }, /* {
            title: "fa-light fa-paypal",
            searchTerms: []
        }, */ {
            title: "fa-light fa-peace",
            searchTerms: []
        }, {
            title: "fa-light fa-pen",
            searchTerms: [ "design", "edit", "update", "write" ]
        }, {
            title: "fa-light fa-pen-alt",
            searchTerms: [ "design", "edit", "update", "write" ]
        }, {
            title: "fa-light fa-pen-fancy",
            searchTerms: [ "design", "edit", "fountain pen", "update", "write" ]
        }, {
            title: "fa-light fa-pen-nib",
            searchTerms: [ "design", "edit", "fountain pen", "update", "write" ]
        }, {
            title: "fa-light fa-pen-square",
            searchTerms: [ "edit", "pencil-square", "update", "write" ]
        }, {
            title: "fa-light fa-pencil-alt",
            searchTerms: [ "design", "edit", "pencil", "update", "write" ]
        }, {
            title: "fa-light fa-pencil-ruler",
            searchTerms: []
        }, {
            title: "fa-light fa-people-carry",
            searchTerms: [ "movers" ]
        }, {
            title: "fa-light fa-percent",
            searchTerms: []
        }, /* {
            title: "fa-light fa-periscope",
            searchTerms: []
        }, */ {
            title: "fa-light fa-person-booth",
            searchTerms: [ "changing", "changing room", "election", "human", "person", "vote", "voting" ]
        }, /* {
            title: "fa-light fa-phabricator",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-phoenix-framework",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-phoenix-squadron",
            searchTerms: []
        }, */ {
            title: "fa-light fa-phone",
            searchTerms: [ "call", "earphone", "number", "support", "telephone", "voice" ]
        }, {
            title: "fa-light fa-phone-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-phone-square",
            searchTerms: [ "call", "number", "support", "telephone", "voice" ]
        }, {
            title: "fa-light fa-phone-volume",
            searchTerms: [ "telephone", "volume-control-phone" ]
        }, /* {
            title: "fa-light fa-php",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pied-piper",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pied-piper-alt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pied-piper-hat",
            searchTerms: [ "clothing" ]
        }, */ /* {
            title: "fa-light fa-pied-piper-pp",
            searchTerms: []
        }, */ {
            title: "fa-light fa-piggy-bank",
            searchTerms: [ "save", "savings" ]
        }, {
            title: "fa-light fa-pills",
            searchTerms: [ "drugs", "medicine" ]
        }, /* {
            title: "fa-light fa-pinterest",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pinterest-p",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-pinterest-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-place-of-worship",
            searchTerms: []
        }, {
            title: "fa-light fa-plane",
            searchTerms: [ "airplane", "destination", "fly", "location", "mode", "travel", "trip" ]
        }, {
            title: "fa-light fa-plane-arrival",
            searchTerms: [ "airplane", "arriving", "destination", "fly", "land", "landing", "location", "mode", "travel", "trip" ]
        }, {
            title: "fa-light fa-plane-departure",
            searchTerms: [ "airplane", "departing", "destination", "fly", "location", "mode", "take off", "taking off", "travel", "trip" ]
        }, {
            title: "fa-light fa-play",
            searchTerms: [ "music", "playing", "sound", "start" ]
        }, {
            title: "fa-light fa-play-circle",
            searchTerms: [ "playing", "start" ]
        }, /* {
            title: "fa-light fa-playstation",
            searchTerms: []
        }, */ {
            title: "fa-light fa-plug",
            searchTerms: [ "connect", "online", "power" ]
        }, {
            title: "fa-light fa-plus",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-light fa-plus-circle",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-light fa-plus-square",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-light fa-podcast",
            searchTerms: []
        }, {
            title: "fa-light fa-poll",
            searchTerms: [ "results", "survey", "vote", "voting" ]
        }, {
            title: "fa-light fa-poll-h",
            searchTerms: [ "results", "survey", "vote", "voting" ]
        }, {
            title: "fa-light fa-poo",
            searchTerms: []
        }, {
            title: "fa-light fa-poo-storm",
            searchTerms: [ "mess", "poop", "shit" ]
        }, {
            title: "fa-light fa-poop",
            searchTerms: []
        }, {
            title: "fa-light fa-portrait",
            searchTerms: []
        }, {
            title: "fa-light fa-pound-sign",
            searchTerms: [ "gbp" ]
        }, {
            title: "fa-light fa-power-off",
            searchTerms: [ "on", "reboot", "restart" ]
        }, {
            title: "fa-light fa-pray",
            searchTerms: []
        }, {
            title: "fa-light fa-praying-hands",
            searchTerms: []
        }, {
            title: "fa-light fa-prescription",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-light fa-prescription-bottle",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-light fa-prescription-bottle-alt",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-light fa-print",
            searchTerms: []
        }, {
            title: "fa-light fa-procedures",
            searchTerms: []
        }, /* {
            title: "fa-light fa-product-hunt",
            searchTerms: []
        }, */ {
            title: "fa-light fa-project-diagram",
            searchTerms: []
        }, /* {
            title: "fa-light fa-pushed",
            searchTerms: []
        }, */ {
            title: "fa-light fa-puzzle-piece",
            searchTerms: [ "add-on", "addon", "section" ]
        }, /* {
            title: "fa-light fa-python",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-qq",
            searchTerms: []
        }, */ {
            title: "fa-light fa-qrcode",
            searchTerms: [ "scan" ]
        }, {
            title: "fa-light fa-question",
            searchTerms: [ "help", "information", "support", "unknown" ]
        }, {
            title: "fa-light fa-question-circle",
            searchTerms: [ "help", "information", "support", "unknown" ]
        }, {
            title: "fa-light fa-quidditch",
            searchTerms: []
        }, /* {
            title: "fa-light fa-quinscape",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-quora",
            searchTerms: []
        }, */ {
            title: "fa-light fa-quote-left",
            searchTerms: []
        }, {
            title: "fa-light fa-quote-right",
            searchTerms: []
        }, {
            title: "fa-light fa-quran",
            searchTerms: [ "book", "islam", "muslim" ]
        }, /* {
            title: "fa-light fa-r-project",
            searchTerms: []
        }, */ {
            title: "fa-light fa-rainbow",
            searchTerms: []
        }, {
            title: "fa-light fa-random",
            searchTerms: [ "shuffle", "sort" ]
        }, /* {
            title: "fa-light fa-ravelry",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-react",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-reacteurope",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-readme",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-rebel",
            searchTerms: []
        }, */ {
            title: "fa-light fa-receipt",
            searchTerms: [ "check", "invoice", "table" ]
        }, {
            title: "fa-light fa-recycle",
            searchTerms: []
        }, /* {
            title: "fa-light fa-red-river",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-reddit",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-reddit-alien",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-reddit-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-redo",
            searchTerms: [ "forward", "refresh", "reload", "repeat" ]
        }, {
            title: "fa-light fa-redo-alt",
            searchTerms: [ "forward", "refresh", "reload", "repeat" ]
        }, {
            title: "fa-light fa-registered",
            searchTerms: []
        }, /* {
            title: "fa-light fa-renren",
            searchTerms: []
        }, */ {
            title: "fa-light fa-reply",
            searchTerms: []
        }, {
            title: "fa-light fa-reply-all",
            searchTerms: []
        }, /* {
            title: "fa-light fa-replyd",
            searchTerms: []
        }, */ {
            title: "fa-light fa-republican",
            searchTerms: [ "american", "conservative", "election", "elephant", "politics", "republican party", "right", "right-wing", "usa" ]
        }, /* {
            title: "fa-light fa-researchgate",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-resolving",
            searchTerms: []
        }, */ {
            title: "fa-light fa-retweet",
            searchTerms: [ "refresh", "reload", "share", "swap" ]
        }, /* {
            title: "fa-light fa-rev",
            searchTerms: []
        }, */ {
            title: "fa-light fa-ribbon",
            searchTerms: [ "badge", "cause", "lapel", "pin" ]
        }, {
            title: "fa-light fa-ring",
            searchTerms: [ "Dungeons & Dragons", "Gollum", "band", "binding", "d&d", "dnd", "fantasy", "jewelry", "precious" ]
        }, {
            title: "fa-light fa-road",
            searchTerms: [ "street" ]
        }, {
            title: "fa-light fa-robot",
            searchTerms: []
        }, {
            title: "fa-light fa-rocket",
            searchTerms: [ "app" ]
        }, /* {
            title: "fa-light fa-rocketchat",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-rockrms",
            searchTerms: []
        }, */ {
            title: "fa-light fa-route",
            searchTerms: []
        }, {
            title: "fa-light fa-rss",
            searchTerms: [ "blog" ]
        }, {
            title: "fa-light fa-rss-square",
            searchTerms: [ "blog", "feed" ]
        }, {
            title: "fa-light fa-ruble-sign",
            searchTerms: [ "rub" ]
        }, {
            title: "fa-light fa-ruler",
            searchTerms: []
        }, {
            title: "fa-light fa-ruler-combined",
            searchTerms: []
        }, {
            title: "fa-light fa-ruler-horizontal",
            searchTerms: []
        }, {
            title: "fa-light fa-ruler-vertical",
            searchTerms: []
        }, {
            title: "fa-light fa-running",
            searchTerms: [ "jog", "sprint" ]
        }, {
            title: "fa-light fa-rupee-sign",
            searchTerms: [ "indian", "inr" ]
        }, {
            title: "fa-light fa-sad-cry",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, {
            title: "fa-light fa-sad-tear",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, /* {
            title: "fa-light fa-safari",
            searchTerms: [ "browser" ]
        }, */ /* {
            title: "fa-light fa-sass",
            searchTerms: []
        }, */ {
            title: "fa-light fa-save",
            searchTerms: [ "floppy", "floppy-o" ]
        }, /* {
            title: "fa-light fa-schlix",
            searchTerms: []
        }, */ {
            title: "fa-light fa-school",
            searchTerms: []
        }, {
            title: "fa-light fa-screwdriver",
            searchTerms: [ "admin", "fix", "repair", "settings", "tool" ]
        }, /* {
            title: "fa-light fa-scribd",
            searchTerms: []
        }, */ {
            title: "fa-light fa-scroll",
            searchTerms: [ "Dungeons & Dragons", "announcement", "d&d", "dnd", "fantasy", "paper" ]
        }, {
            title: "fa-light fa-search",
            searchTerms: [ "bigger", "enlarge", "magnify", "preview", "zoom" ]
        }, {
            title: "fa-light fa-search-dollar",
            searchTerms: []
        }, {
            title: "fa-light fa-search-location",
            searchTerms: []
        }, {
            title: "fa-light fa-search-minus",
            searchTerms: [ "minify", "negative", "smaller", "zoom", "zoom out" ]
        }, {
            title: "fa-light fa-search-plus",
            searchTerms: [ "bigger", "enlarge", "magnify", "positive", "zoom", "zoom in" ]
        }, /* {
            title: "fa-light fa-searchengin",
            searchTerms: []
        }, */ {
            title: "fa-light fa-seedling",
            searchTerms: []
        }, /* {
            title: "fa-light fa-sellcast",
            searchTerms: [ "eercast" ]
        }, */ /* {
            title: "fa-light fa-sellsy",
            searchTerms: []
        }, */ {
            title: "fa-light fa-server",
            searchTerms: [ "cpu" ]
        }, /* {
            title: "fa-light fa-servicestack",
            searchTerms: []
        }, */ {
            title: "fa-light fa-shapes",
            searchTerms: [ "circle", "square", "triangle" ]
        }, {
            title: "fa-light fa-share",
            searchTerms: []
        }, {
            title: "fa-light fa-share-alt",
            searchTerms: []
        }, {
            title: "fa-light fa-share-alt-square",
            searchTerms: []
        }, {
            title: "fa-light fa-share-square",
            searchTerms: [ "send", "social" ]
        }, {
            title: "fa-light fa-shekel-sign",
            searchTerms: [ "ils" ]
        }, {
            title: "fa-light fa-shield-alt",
            searchTerms: [ "achievement", "award", "block", "defend", "security", "winner" ]
        }, {
            title: "fa-light fa-ship",
            searchTerms: [ "boat", "sea" ]
        }, {
            title: "fa-light fa-shipping-fast",
            searchTerms: []
        }, /* {
            title: "fa-light fa-shirtsinbulk",
            searchTerms: []
        }, */ {
            title: "fa-light fa-shoe-prints",
            searchTerms: [ "feet", "footprints", "steps" ]
        }, {
            title: "fa-light fa-shopping-bag",
            searchTerms: []
        }, {
            title: "fa-light fa-shopping-basket",
            searchTerms: []
        }, {
            title: "fa-light fa-shopping-cart",
            searchTerms: [ "buy", "checkout", "payment", "purchase" ]
        }, /* {
            title: "fa-light fa-shopware",
            searchTerms: []
        }, */ {
            title: "fa-light fa-shower",
            searchTerms: []
        }, {
            title: "fa-light fa-shuttle-van",
            searchTerms: [ "machine", "public-transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-sign",
            searchTerms: []
        }, {
            title: "fa-light fa-sign-in-alt",
            searchTerms: [ "arrow", "enter", "join", "log in", "login", "sign in", "sign up", "sign-in", "signin", "signup" ]
        }, {
            title: "fa-light fa-sign-language",
            searchTerms: []
        }, {
            title: "fa-light fa-sign-out-alt",
            searchTerms: [ "arrow", "exit", "leave", "log out", "logout", "sign-out" ]
        }, {
            title: "fa-light fa-signal",
            searchTerms: [ "bars", "graph", "online", "status" ]
        }, {
            title: "fa-light fa-signature",
            searchTerms: [ "John Hancock", "cursive", "name", "writing" ]
        }, /* {
            title: "fa-light fa-simplybuilt",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-sistrix",
            searchTerms: []
        }, */ {
            title: "fa-light fa-sitemap",
            searchTerms: [ "directory", "hierarchy", "ia", "information architecture", "organization" ]
        }, /* {
            title: "fa-light fa-sith",
            searchTerms: []
        }, */ {
            title: "fa-light fa-skull",
            searchTerms: [ "bones", "skeleton", "yorick" ]
        }, {
            title: "fa-light fa-skull-crossbones",
            searchTerms: [ "Dungeons & Dragons", "alert", "bones", "d&d", "danger", "dead", "deadly", "death", "dnd", "fantasy", "halloween", "holiday", "jolly-roger", "pirate", "poison", "skeleton", "warning" ]
        }, /* {
            title: "fa-light fa-skyatlas",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-skype",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-slack",
            searchTerms: [ "anchor", "hash", "hashtag" ]
        }, */ /* {
            title: "fa-light fa-slack-hash",
            searchTerms: [ "anchor", "hash", "hashtag" ]
        }, */ {
            title: "fa-light fa-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-sliders-h",
            searchTerms: [ "settings", "sliders" ]
        }, /* {
            title: "fa-light fa-slideshare",
            searchTerms: []
        }, */ {
            title: "fa-light fa-smile",
            searchTerms: [ "approve", "emoticon", "face", "happy", "rating", "satisfied" ]
        }, {
            title: "fa-light fa-smile-beam",
            searchTerms: [ "emoticon", "face", "happy", "positive" ]
        }, {
            title: "fa-light fa-smile-wink",
            searchTerms: [ "emoticon", "face", "happy" ]
        }, {
            title: "fa-light fa-smog",
            searchTerms: [ "dragon" ]
        }, {
            title: "fa-light fa-smoking",
            searchTerms: [ "cigarette", "nicotine", "smoking status" ]
        }, {
            title: "fa-light fa-smoking-ban",
            searchTerms: [ "no smoking", "non-smoking" ]
        }, /* {
            title: "fa-light fa-snapchat",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-snapchat-ghost",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-snapchat-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-snowflake",
            searchTerms: [ "precipitation", "seasonal", "winter" ]
        }, {
            title: "fa-light fa-socks",
            searchTerms: [ "business socks", "business time", "flight of the conchords", "wednesday" ]
        }, {
            title: "fa-light fa-solar-panel",
            searchTerms: [ "clean", "eco-friendly", "energy", "green", "sun" ]
        }, {
            title: "fa-light fa-sort",
            searchTerms: [ "order" ]
        }, {
            title: "fa-light fa-sort-alpha-down",
            searchTerms: [ "sort-alpha-asc" ]
        }, {
            title: "fa-light fa-sort-alpha-up",
            searchTerms: [ "sort-alpha-desc" ]
        }, {
            title: "fa-light fa-sort-amount-down",
            searchTerms: [ "sort-amount-asc" ]
        }, {
            title: "fa-light fa-sort-amount-up",
            searchTerms: [ "sort-amount-desc" ]
        }, {
            title: "fa-light fa-sort-down",
            searchTerms: [ "arrow", "descending", "sort-desc" ]
        }, {
            title: "fa-light fa-sort-numeric-down",
            searchTerms: [ "numbers", "sort-numeric-asc" ]
        }, {
            title: "fa-light fa-sort-numeric-up",
            searchTerms: [ "numbers", "sort-numeric-desc" ]
        }, {
            title: "fa-light fa-sort-up",
            searchTerms: [ "arrow", "ascending", "sort-asc" ]
        }, /* {
            title: "fa-light fa-soundcloud",
            searchTerms: []
        }, */ {
            title: "fa-light fa-spa",
            searchTerms: [ "flora", "mindfullness", "plant", "wellness" ]
        }, {
            title: "fa-light fa-space-shuttle",
            searchTerms: [ "astronaut", "machine", "nasa", "rocket", "transportation" ]
        }, /* {
            title: "fa-light fa-speakap",
            searchTerms: []
        }, */ {
            title: "fa-light fa-spider",
            searchTerms: [ "arachnid", "bug", "charlotte", "crawl", "eight", "halloween", "holiday" ]
        }, {
            title: "fa-light fa-spinner",
            searchTerms: [ "loading", "progress" ]
        }, {
            title: "fa-light fa-splotch",
            searchTerms: []
        }, /* {
            title: "fa-light fa-spotify",
            searchTerms: []
        }, */ {
            title: "fa-light fa-spray-can",
            searchTerms: []
        }, {
            title: "fa-light fa-square",
            searchTerms: [ "block", "box" ]
        }, {
            title: "fa-light fa-square-full",
            searchTerms: []
        }, {
            title: "fa-light fa-square-root-alt",
            searchTerms: []
        }, /* {
            title: "fa-light fa-squarespace",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-stack-exchange",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-stack-overflow",
            searchTerms: []
        }, */ {
            title: "fa-light fa-stamp",
            searchTerms: []
        }, {
            title: "fa-light fa-star",
            searchTerms: [ "achievement", "award", "favorite", "important", "night", "rating", "score" ]
        }, {
            title: "fa-light fa-star-and-crescent",
            searchTerms: [ "islam", "muslim" ]
        }, {
            title: "fa-light fa-star-half",
            searchTerms: [ "achievement", "award", "rating", "score", "star-half-empty", "star-half-full" ]
        }, {
            title: "fa-light fa-star-half-alt",
            searchTerms: [ "achievement", "award", "rating", "score", "star-half-empty", "star-half-full" ]
        }, {
            title: "fa-light fa-star-of-david",
            searchTerms: [ "jewish", "judaism" ]
        }, {
            title: "fa-light fa-star-of-life",
            searchTerms: []
        }, /* {
            title: "fa-light fa-staylinked",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-steam",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-steam-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-steam-symbol",
            searchTerms: []
        }, */ {
            title: "fa-light fa-step-backward",
            searchTerms: [ "beginning", "first", "previous", "rewind", "start" ]
        }, {
            title: "fa-light fa-step-forward",
            searchTerms: [ "end", "last", "next" ]
        }, {
            title: "fa-light fa-stethoscope",
            searchTerms: []
        }, /* {
            title: "fa-light fa-sticker-mule",
            searchTerms: []
        }, */ {
            title: "fa-light fa-sticky-note",
            searchTerms: []
        }, {
            title: "fa-light fa-stop",
            searchTerms: [ "block", "box", "square" ]
        }, {
            title: "fa-light fa-stop-circle",
            searchTerms: []
        }, {
            title: "fa-light fa-stopwatch",
            searchTerms: [ "time" ]
        }, {
            title: "fa-light fa-store",
            searchTerms: []
        }, {
            title: "fa-light fa-store-alt",
            searchTerms: []
        }, /* {
            title: "fa-light fa-strava",
            searchTerms: []
        }, */ {
            title: "fa-light fa-stream",
            searchTerms: []
        }, {
            title: "fa-light fa-street-view",
            searchTerms: [ "map" ]
        }, {
            title: "fa-light fa-strikethrough",
            searchTerms: []
        }, /* {
            title: "fa-light fa-stripe",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-stripe-s",
            searchTerms: []
        }, */ {
            title: "fa-light fa-stroopwafel",
            searchTerms: [ "dessert", "food", "sweets", "waffle" ]
        }, /* {
            title: "fa-light fa-studiovinari",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-stumbleupon",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-stumbleupon-circle",
            searchTerms: []
        }, */ {
            title: "fa-light fa-subscript",
            searchTerms: []
        }, {
            title: "fa-light fa-subway",
            searchTerms: [ "machine", "railway", "train", "transportation", "vehicle" ]
        }, {
            title: "fa-light fa-suitcase",
            searchTerms: [ "baggage", "luggage", "move", "suitcase", "travel", "trip" ]
        }, {
            title: "fa-light fa-suitcase-rolling",
            searchTerms: []
        }, {
            title: "fa-light fa-sun",
            searchTerms: [ "brighten", "contrast", "day", "lighter", "sol", "solar", "star", "weather" ]
        }, /* {
            title: "fa-light fa-superpowers",
            searchTerms: []
        }, */ {
            title: "fa-light fa-superscript",
            searchTerms: [ "exponential" ]
        }, /* {
            title: "fa-light fa-supple",
            searchTerms: []
        }, */ {
            title: "fa-light fa-surprise",
            searchTerms: [ "emoticon", "face", "shocked" ]
        }, {
            title: "fa-light fa-swatchbook",
            searchTerms: []
        }, {
            title: "fa-light fa-swimmer",
            searchTerms: [ "athlete", "head", "man", "person", "water" ]
        }, {
            title: "fa-light fa-swimming-pool",
            searchTerms: [ "ladder", "recreation", "water" ]
        }, {
            title: "fa-light fa-synagogue",
            searchTerms: [ "building", "jewish", "judaism", "star of david", "temple" ]
        }, {
            title: "fa-light fa-sync",
            searchTerms: [ "exchange", "refresh", "reload", "rotate", "swap" ]
        }, {
            title: "fa-light fa-sync-alt",
            searchTerms: [ "refresh", "reload", "rotate" ]
        }, {
            title: "fa-light fa-syringe",
            searchTerms: [ "immunizations", "needle" ]
        }, {
            title: "fa-light fa-table",
            searchTerms: [ "data", "excel", "spreadsheet" ]
        }, {
            title: "fa-light fa-table-tennis",
            searchTerms: []
        }, {
            title: "fa-light fa-tablet",
            searchTerms: [ "apple", "device", "ipad", "kindle", "screen" ]
        }, {
            title: "fa-light fa-tablet-alt",
            searchTerms: [ "apple", "device", "ipad", "kindle", "screen" ]
        }, {
            title: "fa-light fa-tablets",
            searchTerms: [ "drugs", "medicine" ]
        }, {
            title: "fa-light fa-tachometer-alt",
            searchTerms: [ "dashboard", "tachometer" ]
        }, {
            title: "fa-light fa-tag",
            searchTerms: [ "label" ]
        }, {
            title: "fa-light fa-tags",
            searchTerms: [ "labels" ]
        }, {
            title: "fa-light fa-tape",
            searchTerms: []
        }, {
            title: "fa-light fa-tasks",
            searchTerms: [ "downloading", "downloads", "loading", "progress", "settings" ]
        }, {
            title: "fa-light fa-taxi",
            searchTerms: [ "cab", "cabbie", "car", "car service", "lyft", "machine", "transportation", "uber", "vehicle" ]
        }, /* {
            title: "fa-light fa-teamspeak",
            searchTerms: []
        }, */ {
            title: "fa-light fa-teeth",
            searchTerms: []
        }, {
            title: "fa-light fa-teeth-open",
            searchTerms: []
        }, /* {
            title: "fa-light fa-telegram",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-telegram-plane",
            searchTerms: []
        }, */ {
            title: "fa-light fa-temperature-high",
            searchTerms: [ "mercury", "thermometer", "warm" ]
        }, {
            title: "fa-light fa-temperature-low",
            searchTerms: [ "cool", "mercury", "thermometer" ]
        }, /* {
            title: "fa-light fa-tencent-weibo",
            searchTerms: []
        }, */ {
            title: "fa-light fa-terminal",
            searchTerms: [ "code", "command", "console", "prompt" ]
        }, {
            title: "fa-light fa-text-height",
            searchTerms: []
        }, {
            title: "fa-light fa-text-width",
            searchTerms: []
        }, {
            title: "fa-light fa-th",
            searchTerms: [ "blocks", "boxes", "grid", "squares" ]
        }, {
            title: "fa-light fa-th-large",
            searchTerms: [ "blocks", "boxes", "grid", "squares" ]
        }, {
            title: "fa-light fa-th-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, /* {
            title: "fa-light fa-the-red-yeti",
            searchTerms: []
        }, */ {
            title: "fa-light fa-theater-masks",
            searchTerms: []
        }, /* {
            title: "fa-light fa-themeco",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-themeisle",
            searchTerms: []
        }, */ {
            title: "fa-light fa-thermometer",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-light fa-thermometer-empty",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-light fa-thermometer-full",
            searchTerms: [ "fever", "mercury", "status", "temperature" ]
        }, {
            title: "fa-light fa-thermometer-half",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-light fa-thermometer-quarter",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-light fa-thermometer-three-quarters",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, /* {
            title: "fa-light fa-think-peaks",
            searchTerms: []
        }, */ {
            title: "fa-light fa-thumbs-down",
            searchTerms: [ "disagree", "disapprove", "dislike", "hand", "thumbs-o-down" ]
        }, {
            title: "fa-light fa-thumbs-up",
            searchTerms: [ "agree", "approve", "favorite", "hand", "like", "ok", "okay", "success", "thumbs-o-up", "yes", "you got it dude" ]
        }, {
            title: "fa-light fa-thumbtack",
            searchTerms: [ "coordinates", "location", "marker", "pin", "thumb-tack" ]
        }, {
            title: "fa-light fa-ticket-alt",
            searchTerms: [ "ticket" ]
        }, {
            title: "fa-light fa-times",
            searchTerms: [ "close", "cross", "error", "exit", "incorrect", "notice", "notification", "notify", "problem", "wrong", "x" ]
        }, {
            title: "fa-light fa-times-circle",
            searchTerms: [ "close", "cross", "exit", "incorrect", "notice", "notification", "notify", "problem", "wrong", "x" ]
        }, {
            title: "fa-light fa-tint",
            searchTerms: [ "drop", "droplet", "raindrop", "waterdrop" ]
        }, {
            title: "fa-light fa-tint-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-tired",
            searchTerms: [ "emoticon", "face", "grumpy" ]
        }, {
            title: "fa-light fa-toggle-off",
            searchTerms: [ "switch" ]
        }, {
            title: "fa-light fa-toggle-on",
            searchTerms: [ "switch" ]
        }, {
            title: "fa-light fa-toilet-paper",
            searchTerms: [ "bathroom", "halloween", "holiday", "lavatory", "prank", "restroom", "roll" ]
        }, {
            title: "fa-light fa-toolbox",
            searchTerms: [ "admin", "container", "fix", "repair", "settings", "tools" ]
        }, {
            title: "fa-light fa-tooth",
            searchTerms: [ "bicuspid", "dental", "molar", "mouth", "teeth" ]
        }, {
            title: "fa-light fa-torah",
            searchTerms: [ "book", "jewish", "judaism" ]
        }, {
            title: "fa-light fa-torii-gate",
            searchTerms: [ "building", "shintoism" ]
        }, {
            title: "fa-light fa-tractor",
            searchTerms: []
        }, /* {
            title: "fa-light fa-trade-federation",
            searchTerms: []
        }, */ {
            title: "fa-light fa-trademark",
            searchTerms: []
        }, {
            title: "fa-light fa-traffic-light",
            searchTerms: []
        }, {
            title: "fa-light fa-train",
            searchTerms: [ "bullet", "locomotive", "railway" ]
        }, {
            title: "fa-light fa-transgender",
            searchTerms: [ "intersex" ]
        }, {
            title: "fa-light fa-trash",
            searchTerms: [ "delete", "garbage", "hide", "remove" ]
        }, {
            title: "fa-light fa-trash-alt",
            searchTerms: [ "delete", "garbage", "hide", "remove", "trash", "trash-o" ]
        }, {
            title: "fa-light fa-tree",
            searchTerms: [ "bark", "fall", "flora", "forest", "nature", "plant", "seasonal" ]
        }, /* {
            title: "fa-light fa-trello",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-tripadvisor",
            searchTerms: []
        }, */ {
            title: "fa-light fa-trophy",
            searchTerms: [ "achievement", "award", "cup", "game", "winner" ]
        }, {
            title: "fa-light fa-truck",
            searchTerms: [ "delivery", "shipping" ]
        }, {
            title: "fa-light fa-truck-loading",
            searchTerms: []
        }, {
            title: "fa-light fa-truck-monster",
            searchTerms: []
        }, {
            title: "fa-light fa-truck-moving",
            searchTerms: []
        }, {
            title: "fa-light fa-truck-pickup",
            searchTerms: []
        }, {
            title: "fa-light fa-tshirt",
            searchTerms: [ "cloth", "clothing" ]
        }, {
            title: "fa-light fa-tty",
            searchTerms: []
        }, /* {
            title: "fa-light fa-tumblr",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-tumblr-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-tv",
            searchTerms: [ "computer", "display", "monitor", "television" ]
        }, /* {
            title: "fa-light fa-twitch",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-twitter",
            searchTerms: [ "social network", "tweet" ]
        }, */ /* {
            title: "fa-light fa-twitter-square",
            searchTerms: [ "social network", "tweet" ]
        }, */ /* {
            title: "fa-light fa-typo3",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-uber",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-uikit",
            searchTerms: []
        }, */ {
            title: "fa-light fa-umbrella",
            searchTerms: [ "protection", "rain" ]
        }, {
            title: "fa-light fa-umbrella-beach",
            searchTerms: [ "protection", "recreation", "sun" ]
        }, {
            title: "fa-light fa-underline",
            searchTerms: []
        }, {
            title: "fa-light fa-undo",
            searchTerms: [ "back", "control z", "exchange", "oops", "return", "rotate", "swap" ]
        }, {
            title: "fa-light fa-undo-alt",
            searchTerms: [ "back", "control z", "exchange", "oops", "return", "swap" ]
        }, /* {
            title: "fa-light fa-uniregistry",
            searchTerms: []
        }, */ {
            title: "fa-light fa-universal-access",
            searchTerms: []
        }, {
            title: "fa-light fa-university",
            searchTerms: [ "bank", "institution" ]
        }, {
            title: "fa-light fa-unlink",
            searchTerms: [ "chain", "chain-broken", "remove" ]
        }, {
            title: "fa-light fa-unlock",
            searchTerms: [ "admin", "lock", "password", "protect" ]
        }, {
            title: "fa-light fa-unlock-alt",
            searchTerms: [ "admin", "lock", "password", "protect" ]
        }, /* {
            title: "fa-light fa-untappd",
            searchTerms: []
        }, */ {
            title: "fa-light fa-upload",
            searchTerms: [ "export", "publish" ]
        }, /* {
            title: "fa-light fa-usb",
            searchTerms: []
        }, */ {
            title: "fa-light fa-user",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-light fa-user-alt",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-light fa-user-alt-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-user-astronaut",
            searchTerms: [ "avatar", "clothing", "cosmonaut", "space", "suit" ]
        }, {
            title: "fa-light fa-user-check",
            searchTerms: []
        }, {
            title: "fa-light fa-user-circle",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-light fa-user-clock",
            searchTerms: []
        }, {
            title: "fa-light fa-user-cog",
            searchTerms: []
        }, {
            title: "fa-light fa-user-edit",
            searchTerms: []
        }, {
            title: "fa-light fa-user-friends",
            searchTerms: []
        }, {
            title: "fa-light fa-user-graduate",
            searchTerms: [ "cap", "clothing", "commencement", "gown", "graduation", "student" ]
        }, {
            title: "fa-light fa-user-injured",
            searchTerms: [ "cast", "ouch", "sling" ]
        }, {
            title: "fa-light fa-user-lock",
            searchTerms: []
        }, {
            title: "fa-light fa-user-md",
            searchTerms: [ "doctor", "job", "medical", "nurse", "occupation", "profile" ]
        }, {
            title: "fa-light fa-user-minus",
            searchTerms: [ "delete", "negative", "remove" ]
        }, {
            title: "fa-light fa-user-ninja",
            searchTerms: [ "assassin", "avatar", "dangerous", "deadly", "sneaky" ]
        }, {
            title: "fa-light fa-user-plus",
            searchTerms: [ "positive", "sign up", "signup" ]
        }, {
            title: "fa-light fa-user-secret",
            searchTerms: [ "clothing", "coat", "hat", "incognito", "privacy", "spy", "whisper" ]
        }, {
            title: "fa-light fa-user-shield",
            searchTerms: []
        }, {
            title: "fa-light fa-user-slash",
            searchTerms: [ "ban", "remove" ]
        }, {
            title: "fa-light fa-user-tag",
            searchTerms: []
        }, {
            title: "fa-light fa-user-tie",
            searchTerms: [ "avatar", "business", "clothing", "formal" ]
        }, {
            title: "fa-light fa-user-times",
            searchTerms: [ "archive", "delete", "remove", "x" ]
        }, {
            title: "fa-light fa-users",
            searchTerms: [ "people", "persons", "profiles" ]
        }, {
            title: "fa-light fa-users-cog",
            searchTerms: []
        }, /* {
            title: "fa-light fa-ussunnah",
            searchTerms: []
        }, */ {
            title: "fa-light fa-utensil-spoon",
            searchTerms: [ "spoon" ]
        }, {
            title: "fa-light fa-utensils",
            searchTerms: [ "cutlery", "dinner", "eat", "food", "knife", "restaurant", "spoon" ]
        }, /* {
            title: "fa-light fa-vaadin",
            searchTerms: []
        }, */ {
            title: "fa-light fa-vector-square",
            searchTerms: [ "anchors", "lines", "object" ]
        }, {
            title: "fa-light fa-venus",
            searchTerms: [ "female" ]
        }, {
            title: "fa-light fa-venus-double",
            searchTerms: []
        }, {
            title: "fa-light fa-venus-mars",
            searchTerms: []
        }, /* {
            title: "fa-light fa-viacoin",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-viadeo",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-viadeo-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-vial",
            searchTerms: [ "test tube" ]
        }, {
            title: "fa-light fa-vials",
            searchTerms: [ "lab results", "test tubes" ]
        }, /* {
            title: "fa-light fa-viber",
            searchTerms: []
        }, */ {
            title: "fa-light fa-video",
            searchTerms: [ "camera", "film", "movie", "record", "video-camera" ]
        }, {
            title: "fa-light fa-video-slash",
            searchTerms: []
        }, {
            title: "fa-light fa-vihara",
            searchTerms: [ "buddhism", "buddhist", "building", "monastery" ]
        }, /* {
            title: "fa-light fa-vimeo",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-vimeo-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-vimeo-v",
            searchTerms: [ "vimeo" ]
        }, */ /* {
            title: "fa-light fa-vine",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-vk",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-vnv",
            searchTerms: []
        }, */ {
            title: "fa-light fa-volleyball-ball",
            searchTerms: []
        }, {
            title: "fa-light fa-volume-down",
            searchTerms: [ "audio", "lower", "music", "quieter", "sound", "speaker" ]
        }, {
            title: "fa-light fa-volume-mute",
            searchTerms: []
        }, {
            title: "fa-light fa-volume-off",
            searchTerms: [ "audio", "music", "mute", "sound" ]
        }, {
            title: "fa-light fa-volume-up",
            searchTerms: [ "audio", "higher", "louder", "music", "sound", "speaker" ]
        }, {
            title: "fa-light fa-vote-yea",
            searchTerms: [ "accept", "cast", "election", "politics", "positive", "yes" ]
        }, {
            title: "fa-light fa-vr-cardboard",
            searchTerms: [ "google", "reality", "virtual" ]
        }, /* {
            title: "fa-light fa-vuejs",
            searchTerms: []
        }, */ {
            title: "fa-light fa-walking",
            searchTerms: []
        }, {
            title: "fa-light fa-wallet",
            searchTerms: []
        }, {
            title: "fa-light fa-warehouse",
            searchTerms: []
        }, {
            title: "fa-light fa-water",
            searchTerms: []
        }, /* {
            title: "fa-light fa-weebly",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-weibo",
            searchTerms: []
        }, */ {
            title: "fa-light fa-weight",
            searchTerms: [ "measurement", "scale", "weight" ]
        }, {
            title: "fa-light fa-weight-hanging",
            searchTerms: [ "anvil", "heavy", "measurement" ]
        }, /* {
            title: "fa-light fa-weixin",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-whatsapp",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-whatsapp-square",
            searchTerms: []
        }, */ {
            title: "fa-light fa-wheelchair",
            searchTerms: [ "handicap", "person" ]
        }, /* {
            title: "fa-light fa-whmcs",
            searchTerms: []
        }, */ {
            title: "fa-light fa-wifi",
            searchTerms: []
        }, /* {
            title: "fa-light fa-wikipedia-w",
            searchTerms: []
        }, */ {
            title: "fa-light fa-wind",
            searchTerms: [ "air", "blow", "breeze", "fall", "seasonal" ]
        }, {
            title: "fa-light fa-window-close",
            searchTerms: []
        }, {
            title: "fa-light fa-window-maximize",
            searchTerms: []
        }, {
            title: "fa-light fa-window-minimize",
            searchTerms: []
        }, {
            title: "fa-light fa-window-restore",
            searchTerms: []
        }, /* {
            title: "fa-light fa-windows",
            searchTerms: [ "microsoft" ]
        }, */ {
            title: "fa-light fa-wine-bottle",
            searchTerms: [ "alcohol", "beverage", "drink", "glass", "grapes" ]
        }, {
            title: "fa-light fa-wine-glass",
            searchTerms: [ "alcohol", "beverage", "drink", "grapes" ]
        }, {
            title: "fa-light fa-wine-glass-alt",
            searchTerms: [ "alcohol", "beverage", "drink", "grapes" ]
        }, /* {
            title: "fa-light fa-wix",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wizards-of-the-coast",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, */ /* {
            title: "fa-light fa-wolf-pack-battalion",
            searchTerms: []
        }, */ {
            title: "fa-light fa-won-sign",
            searchTerms: [ "krw" ]
        }, /* {
            title: "fa-light fa-wordpress",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wordpress-simple",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wpbeginner",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wpexplorer",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wpforms",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-wpressr",
            searchTerms: [ "rendact" ]
        }, */ {
            title: "fa-light fa-wrench",
            searchTerms: [ "fix", "settings", "spanner", "tool", "update" ]
        }, {
            title: "fa-light fa-x-ray",
            searchTerms: [ "radiological images", "radiology" ]
        }, /* {
            title: "fa-light fa-xbox",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-xing",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-xing-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-y-combinator",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-yahoo",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-yandex",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-yandex-international",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-yelp",
            searchTerms: []
        }, */ {
            title: "fa-light fa-yen-sign",
            searchTerms: [ "jpy", "money" ]
        }, {
            title: "fa-light fa-yin-yang",
            searchTerms: [ "daoism", "opposites", "taoism" ]
        }, /* {
            title: "fa-light fa-yoast",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-youtube",
            searchTerms: [ "film", "video", "youtube-play", "youtube-square" ]
        }, */ /* {
            title: "fa-light fa-youtube-square",
            searchTerms: []
        }, */ /* {
            title: "fa-light fa-zhihu",
            searchTerms: []
        } */ ]
    });
});